// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentity

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Input to the GetOpenIdTokenForDeveloperIdentity action.
type GetOpenIdTokenForDeveloperIdentityInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	// Each name-value pair represents a user from a public provider or developer
	// provider. If the user is from a developer provider, the name-value pair will
	// follow the syntax "developer_provider_name": "developer_user_identifier".
	// The developer provider is the "domain" by which Cognito will refer to your
	// users; you provided this domain while creating/updating the identity pool.
	// The developer user identifier is an identifier from your backend that uniquely
	// identifies a user. When you create an identity pool, you can specify the
	// supported logins.
	//
	// Logins is a required field
	Logins map[string]string `type:"map" required:"true"`

	// The expiration time of the token, in seconds. You can specify a custom expiration
	// time for the token so that you can cache it. If you don't provide an expiration
	// time, the token is valid for 15 minutes. You can exchange the token with
	// Amazon STS for temporary AWS credentials, which are valid for a maximum of
	// one hour. The maximum token duration you can set is 24 hours. You should
	// take care in setting the expiration time for a token, as there are significant
	// security implications: an attacker could use a leaked token to access your
	// AWS resources for the token's duration.
	//
	// Please provide for a small grace period, usually no more than 5 minutes,
	// to account for clock skew.
	TokenDuration *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s GetOpenIdTokenForDeveloperIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOpenIdTokenForDeveloperIdentityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetOpenIdTokenForDeveloperIdentityInput"}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityId", 1))
	}

	if s.IdentityPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if s.Logins == nil {
		invalidParams.Add(aws.NewErrParamRequired("Logins"))
	}
	if s.TokenDuration != nil && *s.TokenDuration < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("TokenDuration", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returned in response to a successful GetOpenIdTokenForDeveloperIdentity request.
type GetOpenIdTokenForDeveloperIdentityOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// An OpenID token.
	Token *string `type:"string"`
}

// String returns the string representation
func (s GetOpenIdTokenForDeveloperIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetOpenIdTokenForDeveloperIdentity = "GetOpenIdTokenForDeveloperIdentity"

// GetOpenIdTokenForDeveloperIdentityRequest returns a request value for making API operation for
// Amazon Cognito Identity.
//
// Registers (or retrieves) a Cognito IdentityId and an OpenID Connect token
// for a user authenticated by your backend authentication process. Supplying
// multiple logins will create an implicit linked account. You can only specify
// one developer provider as part of the Logins map, which is linked to the
// identity pool. The developer provider is the "domain" by which Cognito will
// refer to your users.
//
// You can use GetOpenIdTokenForDeveloperIdentity to create a new identity and
// to link new logins (that is, user credentials issued by a public provider
// or developer provider) to an existing identity. When you want to create a
// new identity, the IdentityId should be null. When you want to associate a
// new login with an existing authenticated/unauthenticated identity, you can
// do so by providing the existing IdentityId. This API will create the identity
// in the specified IdentityPoolId.
//
// You must use AWS Developer credentials to call this API.
//
//    // Example sending a request using GetOpenIdTokenForDeveloperIdentityRequest.
//    req := client.GetOpenIdTokenForDeveloperIdentityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetOpenIdTokenForDeveloperIdentity
func (c *Client) GetOpenIdTokenForDeveloperIdentityRequest(input *GetOpenIdTokenForDeveloperIdentityInput) GetOpenIdTokenForDeveloperIdentityRequest {
	op := &aws.Operation{
		Name:       opGetOpenIdTokenForDeveloperIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOpenIdTokenForDeveloperIdentityInput{}
	}

	req := c.newRequest(op, input, &GetOpenIdTokenForDeveloperIdentityOutput{})

	return GetOpenIdTokenForDeveloperIdentityRequest{Request: req, Input: input, Copy: c.GetOpenIdTokenForDeveloperIdentityRequest}
}

// GetOpenIdTokenForDeveloperIdentityRequest is the request type for the
// GetOpenIdTokenForDeveloperIdentity API operation.
type GetOpenIdTokenForDeveloperIdentityRequest struct {
	*aws.Request
	Input *GetOpenIdTokenForDeveloperIdentityInput
	Copy  func(*GetOpenIdTokenForDeveloperIdentityInput) GetOpenIdTokenForDeveloperIdentityRequest
}

// Send marshals and sends the GetOpenIdTokenForDeveloperIdentity API request.
func (r GetOpenIdTokenForDeveloperIdentityRequest) Send(ctx context.Context) (*GetOpenIdTokenForDeveloperIdentityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetOpenIdTokenForDeveloperIdentityResponse{
		GetOpenIdTokenForDeveloperIdentityOutput: r.Request.Data.(*GetOpenIdTokenForDeveloperIdentityOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetOpenIdTokenForDeveloperIdentityResponse is the response type for the
// GetOpenIdTokenForDeveloperIdentity API operation.
type GetOpenIdTokenForDeveloperIdentityResponse struct {
	*GetOpenIdTokenForDeveloperIdentityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetOpenIdTokenForDeveloperIdentity request.
func (r *GetOpenIdTokenForDeveloperIdentityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
