// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentity

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// An object representing an Amazon Cognito identity pool.
type UpdateIdentityPoolInput struct {
	_ struct{} `type:"structure"`

	// Enables or disables the Basic (Classic) authentication flow. For more information,
	// see Identity Pools (Federated Identities) Authentication Flow (https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html)
	// in the Amazon Cognito Developer Guide.
	AllowClassicFlow *bool `type:"boolean"`

	// TRUE if the identity pool supports unauthenticated logins.
	//
	// AllowUnauthenticatedIdentities is a required field
	AllowUnauthenticatedIdentities *bool `type:"boolean" required:"true"`

	// A list representing an Amazon Cognito user pool and its client ID.
	CognitoIdentityProviders []CognitoIdentityProvider `type:"list"`

	// The "domain" by which Cognito will refer to your users.
	DeveloperProviderName *string `min:"1" type:"string"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// A string that you provide.
	//
	// IdentityPoolName is a required field
	IdentityPoolName *string `min:"1" type:"string" required:"true"`

	// The tags that are assigned to the identity pool. A tag is a label that you
	// can apply to identity pools to categorize and manage them in different ways,
	// such as by purpose, owner, environment, or other criteria.
	IdentityPoolTags map[string]string `type:"map"`

	// A list of OpendID Connect provider ARNs.
	OpenIdConnectProviderARNs []string `type:"list"`

	// An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
	// pool.
	SamlProviderARNs []string `type:"list"`

	// Optional key:value pairs mapping provider names to provider app IDs.
	SupportedLoginProviders map[string]string `type:"map"`
}

// String returns the string representation
func (s UpdateIdentityPoolInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIdentityPoolInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateIdentityPoolInput"}

	if s.AllowUnauthenticatedIdentities == nil {
		invalidParams.Add(aws.NewErrParamRequired("AllowUnauthenticatedIdentities"))
	}
	if s.DeveloperProviderName != nil && len(*s.DeveloperProviderName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeveloperProviderName", 1))
	}

	if s.IdentityPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if s.IdentityPoolName == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityPoolName"))
	}
	if s.IdentityPoolName != nil && len(*s.IdentityPoolName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityPoolName", 1))
	}
	if s.CognitoIdentityProviders != nil {
		for i, v := range s.CognitoIdentityProviders {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CognitoIdentityProviders", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An object representing an Amazon Cognito identity pool.
type UpdateIdentityPoolOutput struct {
	_ struct{} `type:"structure"`

	// Enables or disables the Basic (Classic) authentication flow. For more information,
	// see Identity Pools (Federated Identities) Authentication Flow (https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html)
	// in the Amazon Cognito Developer Guide.
	AllowClassicFlow *bool `type:"boolean"`

	// TRUE if the identity pool supports unauthenticated logins.
	//
	// AllowUnauthenticatedIdentities is a required field
	AllowUnauthenticatedIdentities *bool `type:"boolean" required:"true"`

	// A list representing an Amazon Cognito user pool and its client ID.
	CognitoIdentityProviders []CognitoIdentityProvider `type:"list"`

	// The "domain" by which Cognito will refer to your users.
	DeveloperProviderName *string `min:"1" type:"string"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// A string that you provide.
	//
	// IdentityPoolName is a required field
	IdentityPoolName *string `min:"1" type:"string" required:"true"`

	// The tags that are assigned to the identity pool. A tag is a label that you
	// can apply to identity pools to categorize and manage them in different ways,
	// such as by purpose, owner, environment, or other criteria.
	IdentityPoolTags map[string]string `type:"map"`

	// A list of OpendID Connect provider ARNs.
	OpenIdConnectProviderARNs []string `type:"list"`

	// An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
	// pool.
	SamlProviderARNs []string `type:"list"`

	// Optional key:value pairs mapping provider names to provider app IDs.
	SupportedLoginProviders map[string]string `type:"map"`
}

// String returns the string representation
func (s UpdateIdentityPoolOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateIdentityPool = "UpdateIdentityPool"

// UpdateIdentityPoolRequest returns a request value for making API operation for
// Amazon Cognito Identity.
//
// Updates an identity pool.
//
// You must use AWS Developer credentials to call this API.
//
//    // Example sending a request using UpdateIdentityPoolRequest.
//    req := client.UpdateIdentityPoolRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UpdateIdentityPool
func (c *Client) UpdateIdentityPoolRequest(input *UpdateIdentityPoolInput) UpdateIdentityPoolRequest {
	op := &aws.Operation{
		Name:       opUpdateIdentityPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateIdentityPoolInput{}
	}

	req := c.newRequest(op, input, &UpdateIdentityPoolOutput{})

	return UpdateIdentityPoolRequest{Request: req, Input: input, Copy: c.UpdateIdentityPoolRequest}
}

// UpdateIdentityPoolRequest is the request type for the
// UpdateIdentityPool API operation.
type UpdateIdentityPoolRequest struct {
	*aws.Request
	Input *UpdateIdentityPoolInput
	Copy  func(*UpdateIdentityPoolInput) UpdateIdentityPoolRequest
}

// Send marshals and sends the UpdateIdentityPool API request.
func (r UpdateIdentityPoolRequest) Send(ctx context.Context) (*UpdateIdentityPoolResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateIdentityPoolResponse{
		UpdateIdentityPoolOutput: r.Request.Data.(*UpdateIdentityPoolOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateIdentityPoolResponse is the response type for the
// UpdateIdentityPool API operation.
type UpdateIdentityPoolResponse struct {
	*UpdateIdentityPoolOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateIdentityPool request.
func (r *UpdateIdentityPoolResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
