// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// You can use this parameter to set an MFA configuration that uses the SMS
// delivery medium.
type AdminSetUserSettingsInput struct {
	_ struct{} `type:"structure"`

	// You can use this parameter only to set an SMS configuration that uses SMS
	// for delivery.
	//
	// MFAOptions is a required field
	MFAOptions []MFAOptionType `type:"list" required:"true"`

	// The ID of the user pool that contains the user that you are setting options
	// for.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user that you are setting options for.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s AdminSetUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminSetUserSettingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AdminSetUserSettingsInput"}

	if s.MFAOptions == nil {
		invalidParams.Add(aws.NewErrParamRequired("MFAOptions"))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if s.Username == nil {
		invalidParams.Add(aws.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}
	if s.MFAOptions != nil {
		for i, v := range s.MFAOptions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MFAOptions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to set user settings as an administrator.
type AdminSetUserSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminSetUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

const opAdminSetUserSettings = "AdminSetUserSettings"

// AdminSetUserSettingsRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// This action is no longer supported. You can use it to configure only SMS
// MFA. You can't use it to configure TOTP software token MFA. To configure
// either type of MFA, use the AdminSetUserMFAPreference action instead.
//
//    // Example sending a request using AdminSetUserSettingsRequest.
//    req := client.AdminSetUserSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings
func (c *Client) AdminSetUserSettingsRequest(input *AdminSetUserSettingsInput) AdminSetUserSettingsRequest {
	op := &aws.Operation{
		Name:       opAdminSetUserSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminSetUserSettingsInput{}
	}

	req := c.newRequest(op, input, &AdminSetUserSettingsOutput{})

	return AdminSetUserSettingsRequest{Request: req, Input: input, Copy: c.AdminSetUserSettingsRequest}
}

// AdminSetUserSettingsRequest is the request type for the
// AdminSetUserSettings API operation.
type AdminSetUserSettingsRequest struct {
	*aws.Request
	Input *AdminSetUserSettingsInput
	Copy  func(*AdminSetUserSettingsInput) AdminSetUserSettingsRequest
}

// Send marshals and sends the AdminSetUserSettings API request.
func (r AdminSetUserSettingsRequest) Send(ctx context.Context) (*AdminSetUserSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AdminSetUserSettingsResponse{
		AdminSetUserSettingsOutput: r.Request.Data.(*AdminSetUserSettingsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AdminSetUserSettingsResponse is the response type for the
// AdminSetUserSettings API operation.
type AdminSetUserSettingsResponse struct {
	*AdminSetUserSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AdminSetUserSettings request.
func (r *AdminSetUserSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
