// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to confirm registration of a user.
type ConfirmSignUpInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for ConfirmSignUp
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The ID of the app client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning AWS Lambda functions to user pool
	// triggers. When you use the ConfirmSignUp API action, Amazon Cognito invokes
	// the function that is assigned to the post confirmation trigger. When Amazon
	// Cognito invokes this function, it passes a JSON payload, which the function
	// receives as input. This payload contains a clientMetadata attribute, which
	// provides the data that you assigned to the ClientMetadata parameter in your
	// ConfirmSignUp request. In your function code in AWS Lambda, you can process
	// the clientMetadata value to enhance your workflow for your specific needs.
	//
	// For more information, see Customizing User Pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// Take the following limitations into consideration when you use the ClientMetadata
	// parameter:
	//
	//    * Amazon Cognito does not store the ClientMetadata value. This data is
	//    available only to AWS Lambda triggers that are assigned to a user pool
	//    to support custom workflows. If your user pool configuration does not
	//    include triggers, the ClientMetadata parameter serves no purpose.
	//
	//    * Amazon Cognito does not validate the ClientMetadata value.
	//
	//    * Amazon Cognito does not encrypt the the ClientMetadata value, so don't
	//    use it to provide sensitive information.
	ClientMetadata map[string]string `type:"map"`

	// The confirmation code sent by a user's request to confirm registration.
	//
	// ConfirmationCode is a required field
	ConfirmationCode *string `min:"1" type:"string" required:"true"`

	// Boolean to be specified to force user confirmation irrespective of existing
	// alias. By default set to False. If this parameter is set to True and the
	// phone number/email used for sign up confirmation already exists as an alias
	// with a different user, the API call will migrate the alias from the previous
	// user to the newly created user being confirmed. If set to False, the API
	// will throw an AliasExistsException error.
	ForceAliasCreation *bool `type:"boolean"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	SecretHash *string `min:"1" type:"string" sensitive:"true"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`

	// The user name of the user whose registration you wish to confirm.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s ConfirmSignUpInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmSignUpInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConfirmSignUpInput"}

	if s.ClientId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientId", 1))
	}

	if s.ConfirmationCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfirmationCode"))
	}
	if s.ConfirmationCode != nil && len(*s.ConfirmationCode) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfirmationCode", 1))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretHash", 1))
	}

	if s.Username == nil {
		invalidParams.Add(aws.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server for the registration confirmation.
type ConfirmSignUpOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ConfirmSignUpOutput) String() string {
	return awsutil.Prettify(s)
}

const opConfirmSignUp = "ConfirmSignUp"

// ConfirmSignUpRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Confirms registration of a user and handles the existing alias from a previous
// user.
//
//    // Example sending a request using ConfirmSignUpRequest.
//    req := client.ConfirmSignUpRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp
func (c *Client) ConfirmSignUpRequest(input *ConfirmSignUpInput) ConfirmSignUpRequest {
	op := &aws.Operation{
		Name:       opConfirmSignUp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmSignUpInput{}
	}

	req := c.newRequest(op, input, &ConfirmSignUpOutput{})
	req.Config.Credentials = aws.AnonymousCredentials

	return ConfirmSignUpRequest{Request: req, Input: input, Copy: c.ConfirmSignUpRequest}
}

// ConfirmSignUpRequest is the request type for the
// ConfirmSignUp API operation.
type ConfirmSignUpRequest struct {
	*aws.Request
	Input *ConfirmSignUpInput
	Copy  func(*ConfirmSignUpInput) ConfirmSignUpRequest
}

// Send marshals and sends the ConfirmSignUp API request.
func (r ConfirmSignUpRequest) Send(ctx context.Context) (*ConfirmSignUpResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ConfirmSignUpResponse{
		ConfirmSignUpOutput: r.Request.Data.(*ConfirmSignUpOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ConfirmSignUpResponse is the response type for the
// ConfirmSignUp API operation.
type ConfirmSignUpResponse struct {
	*ConfirmSignUpOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ConfirmSignUp request.
func (r *ConfirmSignUpResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
