// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to sign out all devices.
type GlobalSignOutInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s GlobalSignOutInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalSignOutInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GlobalSignOutInput"}

	if s.AccessToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response to the request to sign out all devices.
type GlobalSignOutOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GlobalSignOutOutput) String() string {
	return awsutil.Prettify(s)
}

const opGlobalSignOut = "GlobalSignOut"

// GlobalSignOutRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Signs out users from all devices. It also invalidates all refresh tokens
// issued to a user. The user's current access and Id tokens remain valid until
// their expiry. Access and Id tokens expire one hour after they are issued.
//
//    // Example sending a request using GlobalSignOutRequest.
//    req := client.GlobalSignOutRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GlobalSignOut
func (c *Client) GlobalSignOutRequest(input *GlobalSignOutInput) GlobalSignOutRequest {
	op := &aws.Operation{
		Name:       opGlobalSignOut,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GlobalSignOutInput{}
	}

	req := c.newRequest(op, input, &GlobalSignOutOutput{})

	return GlobalSignOutRequest{Request: req, Input: input, Copy: c.GlobalSignOutRequest}
}

// GlobalSignOutRequest is the request type for the
// GlobalSignOut API operation.
type GlobalSignOutRequest struct {
	*aws.Request
	Input *GlobalSignOutInput
	Copy  func(*GlobalSignOutInput) GlobalSignOutRequest
}

// Send marshals and sends the GlobalSignOut API request.
func (r GlobalSignOutRequest) Send(ctx context.Context) (*GlobalSignOutResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GlobalSignOutResponse{
		GlobalSignOutOutput: r.Request.Data.(*GlobalSignOutOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GlobalSignOutResponse is the response type for the
// GlobalSignOut API operation.
type GlobalSignOutResponse struct {
	*GlobalSignOutOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GlobalSignOut request.
func (r *GlobalSignOutResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
