// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to set user settings.
type SetUserSettingsInput struct {
	_ struct{} `type:"structure"`

	// The access token for the set user settings request.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true" sensitive:"true"`

	// You can use this parameter only to set an SMS configuration that uses SMS
	// for delivery.
	//
	// MFAOptions is a required field
	MFAOptions []MFAOptionType `type:"list" required:"true"`
}

// String returns the string representation
func (s SetUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetUserSettingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetUserSettingsInput"}

	if s.AccessToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessToken"))
	}

	if s.MFAOptions == nil {
		invalidParams.Add(aws.NewErrParamRequired("MFAOptions"))
	}
	if s.MFAOptions != nil {
		for i, v := range s.MFAOptions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MFAOptions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response from the server for a set user settings request.
type SetUserSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetUserSettings = "SetUserSettings"

// SetUserSettingsRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// This action is no longer supported. You can use it to configure only SMS
// MFA. You can't use it to configure TOTP software token MFA. To configure
// either type of MFA, use the SetUserMFAPreference action instead.
//
//    // Example sending a request using SetUserSettingsRequest.
//    req := client.SetUserSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserSettings
func (c *Client) SetUserSettingsRequest(input *SetUserSettingsInput) SetUserSettingsRequest {
	op := &aws.Operation{
		Name:       opSetUserSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetUserSettingsInput{}
	}

	req := c.newRequest(op, input, &SetUserSettingsOutput{})
	req.Config.Credentials = aws.AnonymousCredentials

	return SetUserSettingsRequest{Request: req, Input: input, Copy: c.SetUserSettingsRequest}
}

// SetUserSettingsRequest is the request type for the
// SetUserSettings API operation.
type SetUserSettingsRequest struct {
	*aws.Request
	Input *SetUserSettingsInput
	Copy  func(*SetUserSettingsInput) SetUserSettingsRequest
}

// Send marshals and sends the SetUserSettings API request.
func (r SetUserSettingsRequest) Send(ctx context.Context) (*SetUserSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetUserSettingsResponse{
		SetUserSettingsOutput: r.Request.Data.(*SetUserSettingsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetUserSettingsResponse is the response type for the
// SetUserSettings API operation.
type SetUserSettingsResponse struct {
	*SetUserSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetUserSettings request.
func (r *SetUserSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
