// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// The data type for AccountRecoverySetting.
type AccountRecoverySettingType struct {
	_ struct{} `type:"structure"`

	// The list of RecoveryOptionTypes.
	RecoveryMechanisms []RecoveryOptionType `min:"1" type:"list"`
}

// String returns the string representation
func (s AccountRecoverySettingType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountRecoverySettingType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccountRecoverySettingType"}
	if s.RecoveryMechanisms != nil && len(s.RecoveryMechanisms) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RecoveryMechanisms", 1))
	}
	if s.RecoveryMechanisms != nil {
		for i, v := range s.RecoveryMechanisms {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RecoveryMechanisms", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Account takeover action type.
type AccountTakeoverActionType struct {
	_ struct{} `type:"structure"`

	// The event action.
	//
	//    * BLOCK Choosing this action will block the request.
	//
	//    * MFA_IF_CONFIGURED Throw MFA challenge if user has configured it, else
	//    allow the request.
	//
	//    * MFA_REQUIRED Throw MFA challenge if user has configured it, else block
	//    the request.
	//
	//    * NO_ACTION Allow the user sign-in.
	//
	// EventAction is a required field
	EventAction AccountTakeoverEventActionType `type:"string" required:"true" enum:"true"`

	// Flag specifying whether to send a notification.
	//
	// Notify is a required field
	Notify *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s AccountTakeoverActionType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountTakeoverActionType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccountTakeoverActionType"}
	if len(s.EventAction) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("EventAction"))
	}

	if s.Notify == nil {
		invalidParams.Add(aws.NewErrParamRequired("Notify"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Account takeover actions type.
type AccountTakeoverActionsType struct {
	_ struct{} `type:"structure"`

	// Action to take for a high risk.
	HighAction *AccountTakeoverActionType `type:"structure"`

	// Action to take for a low risk.
	LowAction *AccountTakeoverActionType `type:"structure"`

	// Action to take for a medium risk.
	MediumAction *AccountTakeoverActionType `type:"structure"`
}

// String returns the string representation
func (s AccountTakeoverActionsType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountTakeoverActionsType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccountTakeoverActionsType"}
	if s.HighAction != nil {
		if err := s.HighAction.Validate(); err != nil {
			invalidParams.AddNested("HighAction", err.(aws.ErrInvalidParams))
		}
	}
	if s.LowAction != nil {
		if err := s.LowAction.Validate(); err != nil {
			invalidParams.AddNested("LowAction", err.(aws.ErrInvalidParams))
		}
	}
	if s.MediumAction != nil {
		if err := s.MediumAction.Validate(); err != nil {
			invalidParams.AddNested("MediumAction", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configuration for mitigation actions and notification for different levels
// of risk detected for a potential account takeover.
type AccountTakeoverRiskConfigurationType struct {
	_ struct{} `type:"structure"`

	// Account takeover risk configuration actions
	//
	// Actions is a required field
	Actions *AccountTakeoverActionsType `type:"structure" required:"true"`

	// The notify configuration used to construct email notifications.
	NotifyConfiguration *NotifyConfigurationType `type:"structure"`
}

// String returns the string representation
func (s AccountTakeoverRiskConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountTakeoverRiskConfigurationType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccountTakeoverRiskConfigurationType"}

	if s.Actions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil {
		if err := s.Actions.Validate(); err != nil {
			invalidParams.AddNested("Actions", err.(aws.ErrInvalidParams))
		}
	}
	if s.NotifyConfiguration != nil {
		if err := s.NotifyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NotifyConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration for creating a new user profile.
type AdminCreateUserConfigType struct {
	_ struct{} `type:"structure"`

	// Set to True if only the administrator is allowed to create user profiles.
	// Set to False if users can sign themselves up via an app.
	AllowAdminCreateUserOnly *bool `type:"boolean"`

	// The message template to be used for the welcome message to new users.
	//
	// See also Customizing User Invitation Messages (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization).
	InviteMessageTemplate *MessageTemplateType `type:"structure"`

	// The user account expiration limit, in days, after which the account is no
	// longer usable. To reset the account after that time limit, you must call
	// AdminCreateUser again, specifying "RESEND" for the MessageAction parameter.
	// The default value for this parameter is 7.
	//
	// If you set a value for TemporaryPasswordValidityDays in PasswordPolicy, that
	// value will be used and UnusedAccountValidityDays will be deprecated for that
	// user pool.
	UnusedAccountValidityDays *int64 `type:"integer"`
}

// String returns the string representation
func (s AdminCreateUserConfigType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminCreateUserConfigType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AdminCreateUserConfigType"}
	if s.InviteMessageTemplate != nil {
		if err := s.InviteMessageTemplate.Validate(); err != nil {
			invalidParams.AddNested("InviteMessageTemplate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Amazon Pinpoint analytics configuration for collecting metrics for a
// user pool.
//
// Cognito User Pools only supports sending events to Amazon Pinpoint projects
// in the US East (N. Virginia) us-east-1 Region, regardless of the region in
// which the user pool resides.
type AnalyticsConfigurationType struct {
	_ struct{} `type:"structure"`

	// The application ID for an Amazon Pinpoint application.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The external ID.
	//
	// ExternalId is a required field
	ExternalId *string `type:"string" required:"true"`

	// The ARN of an IAM role that authorizes Amazon Cognito to publish events to
	// Amazon Pinpoint analytics.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// If UserDataShared is true, Amazon Cognito will include user data in the events
	// it publishes to Amazon Pinpoint analytics.
	UserDataShared *bool `type:"boolean"`
}

// String returns the string representation
func (s AnalyticsConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsConfigurationType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsConfigurationType"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.ExternalId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExternalId"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An Amazon Pinpoint analytics endpoint.
//
// An endpoint uniquely identifies a mobile device, email address, or phone
// number that can receive messages from Amazon Pinpoint analytics.
//
// Cognito User Pools only supports sending events to Amazon Pinpoint projects
// in the US East (N. Virginia) us-east-1 Region, regardless of the region in
// which the user pool resides.
type AnalyticsMetadataType struct {
	_ struct{} `type:"structure"`

	// The endpoint ID.
	AnalyticsEndpointId *string `type:"string"`
}

// String returns the string representation
func (s AnalyticsMetadataType) String() string {
	return awsutil.Prettify(s)
}

// Specifies whether the attribute is standard or custom.
type AttributeType struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the attribute.
	Value *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s AttributeType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttributeType"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The authentication event type.
type AuthEventType struct {
	_ struct{} `type:"structure"`

	// The challenge responses.
	ChallengeResponses []ChallengeResponseType `type:"list"`

	// The creation date
	CreationDate *time.Time `type:"timestamp"`

	// The user context data captured at the time of an event request. It provides
	// additional information about the client from which event the request is received.
	EventContextData *EventContextDataType `type:"structure"`

	// A flag specifying the user feedback captured at the time of an event request
	// is good or bad.
	EventFeedback *EventFeedbackType `type:"structure"`

	// The event ID.
	EventId *string `type:"string"`

	// The event response.
	EventResponse EventResponseType `type:"string" enum:"true"`

	// The event risk.
	EventRisk *EventRiskType `type:"structure"`

	// The event type.
	EventType EventType `type:"string" enum:"true"`
}

// String returns the string representation
func (s AuthEventType) String() string {
	return awsutil.Prettify(s)
}

// The authentication result.
type AuthenticationResultType struct {
	_ struct{} `type:"structure"`

	// The access token.
	AccessToken *string `type:"string" sensitive:"true"`

	// The expiration period of the authentication result in seconds.
	ExpiresIn *int64 `type:"integer"`

	// The ID token.
	IdToken *string `type:"string" sensitive:"true"`

	// The new device metadata from an authentication result.
	NewDeviceMetadata *NewDeviceMetadataType `type:"structure"`

	// The refresh token.
	RefreshToken *string `type:"string" sensitive:"true"`

	// The token type.
	TokenType *string `type:"string"`
}

// String returns the string representation
func (s AuthenticationResultType) String() string {
	return awsutil.Prettify(s)
}

// The challenge response type.
type ChallengeResponseType struct {
	_ struct{} `type:"structure"`

	// The challenge name
	ChallengeName ChallengeName `type:"string" enum:"true"`

	// The challenge response.
	ChallengeResponse ChallengeResponse `type:"string" enum:"true"`
}

// String returns the string representation
func (s ChallengeResponseType) String() string {
	return awsutil.Prettify(s)
}

// The code delivery details being returned from the server.
type CodeDeliveryDetailsType struct {
	_ struct{} `type:"structure"`

	// The attribute name.
	AttributeName *string `min:"1" type:"string"`

	// The delivery medium (email message or phone number).
	DeliveryMedium DeliveryMediumType `type:"string" enum:"true"`

	// The destination for the code delivery details.
	Destination *string `type:"string"`
}

// String returns the string representation
func (s CodeDeliveryDetailsType) String() string {
	return awsutil.Prettify(s)
}

// The compromised credentials actions type
type CompromisedCredentialsActionsType struct {
	_ struct{} `type:"structure"`

	// The event action.
	//
	// EventAction is a required field
	EventAction CompromisedCredentialsEventActionType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CompromisedCredentialsActionsType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompromisedCredentialsActionsType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CompromisedCredentialsActionsType"}
	if len(s.EventAction) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("EventAction"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The compromised credentials risk configuration type.
type CompromisedCredentialsRiskConfigurationType struct {
	_ struct{} `type:"structure"`

	// The compromised credentials risk configuration actions.
	//
	// Actions is a required field
	Actions *CompromisedCredentialsActionsType `type:"structure" required:"true"`

	// Perform the action for these events. The default is to perform all events
	// if no event filter is specified.
	EventFilter []EventFilterType `type:"list"`
}

// String returns the string representation
func (s CompromisedCredentialsRiskConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompromisedCredentialsRiskConfigurationType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CompromisedCredentialsRiskConfigurationType"}

	if s.Actions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil {
		if err := s.Actions.Validate(); err != nil {
			invalidParams.AddNested("Actions", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contextual user data type used for evaluating the risk of an unexpected event
// by Amazon Cognito advanced security.
type ContextDataType struct {
	_ struct{} `type:"structure"`

	// Encoded data containing device fingerprinting details, collected using the
	// Amazon Cognito context data collection library.
	EncodedData *string `type:"string"`

	// HttpHeaders received on your server in same order.
	//
	// HttpHeaders is a required field
	HttpHeaders []HttpHeader `type:"list" required:"true"`

	// Source IP address of your user.
	//
	// IpAddress is a required field
	IpAddress *string `type:"string" required:"true"`

	// Your server endpoint where this API is invoked.
	//
	// ServerName is a required field
	ServerName *string `type:"string" required:"true"`

	// Your server path where this API is invoked.
	//
	// ServerPath is a required field
	ServerPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ContextDataType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContextDataType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContextDataType"}

	if s.HttpHeaders == nil {
		invalidParams.Add(aws.NewErrParamRequired("HttpHeaders"))
	}

	if s.IpAddress == nil {
		invalidParams.Add(aws.NewErrParamRequired("IpAddress"))
	}

	if s.ServerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerName"))
	}

	if s.ServerPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration for a custom domain that hosts the sign-up and sign-in
// webpages for your application.
type CustomDomainConfigType struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an AWS Certificate Manager SSL certificate.
	// You use this certificate for the subdomain of your custom domain.
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CustomDomainConfigType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomDomainConfigType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CustomDomainConfigType"}

	if s.CertificateArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration for the user pool's device tracking.
type DeviceConfigurationType struct {
	_ struct{} `type:"structure"`

	// Indicates whether a challenge is required on a new device. Only applicable
	// to a new device.
	ChallengeRequiredOnNewDevice *bool `type:"boolean"`

	// If true, a device is only remembered on user prompt.
	DeviceOnlyRememberedOnUserPrompt *bool `type:"boolean"`
}

// String returns the string representation
func (s DeviceConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// The device verifier against which it will be authenticated.
type DeviceSecretVerifierConfigType struct {
	_ struct{} `type:"structure"`

	// The password verifier.
	PasswordVerifier *string `type:"string"`

	// The salt.
	Salt *string `type:"string"`
}

// String returns the string representation
func (s DeviceSecretVerifierConfigType) String() string {
	return awsutil.Prettify(s)
}

// The device type.
type DeviceType struct {
	_ struct{} `type:"structure"`

	// The device attributes.
	DeviceAttributes []AttributeType `type:"list"`

	// The creation date of the device.
	DeviceCreateDate *time.Time `type:"timestamp"`

	// The device key.
	DeviceKey *string `min:"1" type:"string"`

	// The date in which the device was last authenticated.
	DeviceLastAuthenticatedDate *time.Time `type:"timestamp"`

	// The last modified date of the device.
	DeviceLastModifiedDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DeviceType) String() string {
	return awsutil.Prettify(s)
}

// A container for information about a domain.
type DomainDescriptionType struct {
	_ struct{} `type:"structure"`

	// The AWS account ID for the user pool owner.
	AWSAccountId *string `type:"string"`

	// The ARN of the CloudFront distribution.
	CloudFrontDistribution *string `type:"string"`

	// The configuration for a custom domain that hosts the sign-up and sign-in
	// webpages for your application.
	CustomDomainConfig *CustomDomainConfigType `type:"structure"`

	// The domain string.
	Domain *string `min:"1" type:"string"`

	// The S3 bucket where the static files for this domain are stored.
	S3Bucket *string `min:"3" type:"string"`

	// The domain status.
	Status DomainStatusType `type:"string" enum:"true"`

	// The user pool ID.
	UserPoolId *string `min:"1" type:"string"`

	// The app version.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DomainDescriptionType) String() string {
	return awsutil.Prettify(s)
}

// The email configuration type.
type EmailConfigurationType struct {
	_ struct{} `type:"structure"`

	// The set of configuration rules that can be applied to emails sent using Amazon
	// SES. A configuration set is applied to an email by including a reference
	// to the configuration set in the headers of the email. Once applied, all of
	// the rules in that configuration set are applied to the email. Configuration
	// sets can be used to apply the following types of rules to emails:
	//
	//    * Event publishing – Amazon SES can track the number of send, delivery,
	//    open, click, bounce, and complaint events for each email sent. Use event
	//    publishing to send information about these events to other AWS services
	//    such as SNS and CloudWatch.
	//
	//    * IP pool management – When leasing dedicated IP addresses with Amazon
	//    SES, you can create groups of IP addresses, called dedicated IP pools.
	//    You can then associate the dedicated IP pools with configuration sets.
	ConfigurationSet *string `min:"1" type:"string"`

	// Specifies whether Amazon Cognito emails your users by using its built-in
	// email functionality or your Amazon SES email configuration. Specify one of
	// the following values:
	//
	// COGNITO_DEFAULT
	//
	// When Amazon Cognito emails your users, it uses its built-in email functionality.
	// When you use the default option, Amazon Cognito allows only a limited number
	// of emails each day for your user pool. For typical production environments,
	// the default email limit is below the required delivery volume. To achieve
	// a higher delivery volume, specify DEVELOPER to use your Amazon SES email
	// configuration.
	//
	// To look up the email delivery limit for the default option, see Limits in
	// Amazon Cognito (https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html)
	// in the Amazon Cognito Developer Guide.
	//
	// The default FROM address is no-reply@verificationemail.com. To customize
	// the FROM address, provide the ARN of an Amazon SES verified email address
	// for the SourceArn parameter.
	//
	// DEVELOPER
	//
	// When Amazon Cognito emails your users, it uses your Amazon SES configuration.
	// Amazon Cognito calls Amazon SES on your behalf to send email from your verified
	// email address. When you use this option, the email delivery limits are the
	// same limits that apply to your Amazon SES verified email address in your
	// AWS account.
	//
	// If you use this option, you must provide the ARN of an Amazon SES verified
	// email address for the SourceArn parameter.
	//
	// Before Amazon Cognito can email your users, it requires additional permissions
	// to call Amazon SES on your behalf. When you update your user pool with this
	// option, Amazon Cognito creates a service-linked role, which is a type of
	// IAM role, in your AWS account. This role contains the permissions that allow
	// Amazon Cognito to access Amazon SES and send email messages with your address.
	// For more information about the service-linked role that Amazon Cognito creates,
	// see Using Service-Linked Roles for Amazon Cognito (https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html)
	// in the Amazon Cognito Developer Guide.
	EmailSendingAccount EmailSendingAccountType `type:"string" enum:"true"`

	// Identifies either the sender’s email address or the sender’s name with
	// their email address. For example, testuser@example.com or Test User <testuser@example.com>.
	// This address will appear before the body of the email.
	From *string `type:"string"`

	// The destination to which the receiver of the email should reply to.
	ReplyToEmailAddress *string `type:"string"`

	// The Amazon Resource Name (ARN) of a verified email address in Amazon SES.
	// This email address is used in one of the following ways, depending on the
	// value that you specify for the EmailSendingAccount parameter:
	//
	//    * If you specify COGNITO_DEFAULT, Amazon Cognito uses this address as
	//    the custom FROM address when it emails your users by using its built-in
	//    email account.
	//
	//    * If you specify DEVELOPER, Amazon Cognito emails your users with this
	//    address by calling Amazon SES on your behalf.
	SourceArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s EmailConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmailConfigurationType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EmailConfigurationType"}
	if s.ConfigurationSet != nil && len(*s.ConfigurationSet) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigurationSet", 1))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the user context data captured at the time of an event request.
type EventContextDataType struct {
	_ struct{} `type:"structure"`

	// The user's city.
	City *string `type:"string"`

	// The user's country.
	Country *string `type:"string"`

	// The user's device name.
	DeviceName *string `type:"string"`

	// The user's IP address.
	IpAddress *string `type:"string"`

	// The user's time zone.
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s EventContextDataType) String() string {
	return awsutil.Prettify(s)
}

// Specifies the event feedback type.
type EventFeedbackType struct {
	_ struct{} `type:"structure"`

	// The event feedback date.
	FeedbackDate *time.Time `type:"timestamp"`

	// The event feedback value.
	//
	// FeedbackValue is a required field
	FeedbackValue FeedbackValueType `type:"string" required:"true" enum:"true"`

	// The provider.
	//
	// Provider is a required field
	Provider *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EventFeedbackType) String() string {
	return awsutil.Prettify(s)
}

// The event risk type.
type EventRiskType struct {
	_ struct{} `type:"structure"`

	// Indicates whether compromised credentials were detected during an authentication
	// event.
	CompromisedCredentialsDetected *bool `type:"boolean"`

	// The risk decision.
	RiskDecision RiskDecisionType `type:"string" enum:"true"`

	// The risk level.
	RiskLevel RiskLevelType `type:"string" enum:"true"`
}

// String returns the string representation
func (s EventRiskType) String() string {
	return awsutil.Prettify(s)
}

// The group type.
type GroupType struct {
	_ struct{} `type:"structure"`

	// The date the group was created.
	CreationDate *time.Time `type:"timestamp"`

	// A string containing the description of the group.
	Description *string `type:"string"`

	// The name of the group.
	GroupName *string `min:"1" type:"string"`

	// The date the group was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// A nonnegative integer value that specifies the precedence of this group relative
	// to the other groups that a user can belong to in the user pool. If a user
	// belongs to two or more groups, it is the group with the highest precedence
	// whose role ARN will be used in the cognito:roles and cognito:preferred_role
	// claims in the user's tokens. Groups with higher Precedence values take precedence
	// over groups with lower Precedence values or with null Precedence values.
	//
	// Two groups can have the same Precedence value. If this happens, neither group
	// takes precedence over the other. If two groups with the same Precedence have
	// the same role ARN, that role is used in the cognito:preferred_role claim
	// in tokens for users in each group. If the two groups have different role
	// ARNs, the cognito:preferred_role claim is not set in users' tokens.
	//
	// The default Precedence value is null.
	Precedence *int64 `type:"integer"`

	// The role ARN for the group.
	RoleArn *string `min:"20" type:"string"`

	// The user pool ID for the user pool.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GroupType) String() string {
	return awsutil.Prettify(s)
}

// The HTTP header.
type HttpHeader struct {
	_ struct{} `type:"structure"`

	// The header name
	HeaderName *string `locationName:"headerName" type:"string"`

	// The header value.
	HeaderValue *string `locationName:"headerValue" type:"string"`
}

// String returns the string representation
func (s HttpHeader) String() string {
	return awsutil.Prettify(s)
}

// A container for information about an identity provider.
type IdentityProviderType struct {
	_ struct{} `type:"structure"`

	// A mapping of identity provider attributes to standard and custom user pool
	// attributes.
	AttributeMapping map[string]string `type:"map"`

	// The date the identity provider was created.
	CreationDate *time.Time `type:"timestamp"`

	// A list of identity provider identifiers.
	IdpIdentifiers []string `type:"list"`

	// The date the identity provider was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The identity provider details. The following list describes the provider
	// detail keys for each identity provider type.
	//
	//    * For Google, Facebook and Login with Amazon: client_id client_secret
	//    authorize_scopes
	//
	//    * For Sign in with Apple: client_id team_id key_id private_key authorize_scopes
	//
	//    * For OIDC providers: client_id client_secret attributes_request_method
	//    oidc_issuer authorize_scopes authorize_url if not available from discovery
	//    URL specified by oidc_issuer key token_url if not available from discovery
	//    URL specified by oidc_issuer key attributes_url if not available from
	//    discovery URL specified by oidc_issuer key jwks_uri if not available from
	//    discovery URL specified by oidc_issuer key authorize_scopes
	//
	//    * For SAML providers: MetadataFile OR MetadataURL IDPSignOut optional
	ProviderDetails map[string]string `type:"map"`

	// The identity provider name.
	ProviderName *string `min:"1" type:"string"`

	// The identity provider type.
	ProviderType IdentityProviderTypeType `type:"string" enum:"true"`

	// The user pool ID.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IdentityProviderType) String() string {
	return awsutil.Prettify(s)
}

// Specifies the configuration for AWS Lambda triggers.
type LambdaConfigType struct {
	_ struct{} `type:"structure"`

	// Creates an authentication challenge.
	CreateAuthChallenge *string `min:"20" type:"string"`

	// A custom Message AWS Lambda trigger.
	CustomMessage *string `min:"20" type:"string"`

	// Defines the authentication challenge.
	DefineAuthChallenge *string `min:"20" type:"string"`

	// A post-authentication AWS Lambda trigger.
	PostAuthentication *string `min:"20" type:"string"`

	// A post-confirmation AWS Lambda trigger.
	PostConfirmation *string `min:"20" type:"string"`

	// A pre-authentication AWS Lambda trigger.
	PreAuthentication *string `min:"20" type:"string"`

	// A pre-registration AWS Lambda trigger.
	PreSignUp *string `min:"20" type:"string"`

	// A Lambda trigger that is invoked before token generation.
	PreTokenGeneration *string `min:"20" type:"string"`

	// The user migration Lambda config type.
	UserMigration *string `min:"20" type:"string"`

	// Verifies the authentication challenge response.
	VerifyAuthChallengeResponse *string `min:"20" type:"string"`
}

// String returns the string representation
func (s LambdaConfigType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaConfigType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaConfigType"}
	if s.CreateAuthChallenge != nil && len(*s.CreateAuthChallenge) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("CreateAuthChallenge", 20))
	}
	if s.CustomMessage != nil && len(*s.CustomMessage) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("CustomMessage", 20))
	}
	if s.DefineAuthChallenge != nil && len(*s.DefineAuthChallenge) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("DefineAuthChallenge", 20))
	}
	if s.PostAuthentication != nil && len(*s.PostAuthentication) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("PostAuthentication", 20))
	}
	if s.PostConfirmation != nil && len(*s.PostConfirmation) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("PostConfirmation", 20))
	}
	if s.PreAuthentication != nil && len(*s.PreAuthentication) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("PreAuthentication", 20))
	}
	if s.PreSignUp != nil && len(*s.PreSignUp) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("PreSignUp", 20))
	}
	if s.PreTokenGeneration != nil && len(*s.PreTokenGeneration) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("PreTokenGeneration", 20))
	}
	if s.UserMigration != nil && len(*s.UserMigration) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("UserMigration", 20))
	}
	if s.VerifyAuthChallengeResponse != nil && len(*s.VerifyAuthChallengeResponse) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("VerifyAuthChallengeResponse", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This data type is no longer supported. You can use it only for SMS MFA configurations.
// You can't use it for TOTP software token MFA configurations.
//
// To set either type of MFA configuration, use the AdminSetUserMFAPreference
// or SetUserMFAPreference actions.
//
// To look up information about either type of MFA configuration, use the AdminGetUserResponse$UserMFASettingList
// or GetUserResponse$UserMFASettingList responses.
type MFAOptionType struct {
	_ struct{} `type:"structure"`

	// The attribute name of the MFA option type. The only valid value is phone_number.
	AttributeName *string `min:"1" type:"string"`

	// The delivery medium to send the MFA code. You can use this parameter to set
	// only the SMS delivery medium value.
	DeliveryMedium DeliveryMediumType `type:"string" enum:"true"`
}

// String returns the string representation
func (s MFAOptionType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MFAOptionType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MFAOptionType"}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AttributeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The message template structure.
type MessageTemplateType struct {
	_ struct{} `type:"structure"`

	// The message template for email messages.
	EmailMessage *string `min:"6" type:"string"`

	// The subject line for email messages.
	EmailSubject *string `min:"1" type:"string"`

	// The message template for SMS messages.
	SMSMessage *string `min:"6" type:"string"`
}

// String returns the string representation
func (s MessageTemplateType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageTemplateType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MessageTemplateType"}
	if s.EmailMessage != nil && len(*s.EmailMessage) < 6 {
		invalidParams.Add(aws.NewErrParamMinLen("EmailMessage", 6))
	}
	if s.EmailSubject != nil && len(*s.EmailSubject) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EmailSubject", 1))
	}
	if s.SMSMessage != nil && len(*s.SMSMessage) < 6 {
		invalidParams.Add(aws.NewErrParamMinLen("SMSMessage", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The new device metadata type.
type NewDeviceMetadataType struct {
	_ struct{} `type:"structure"`

	// The device group key.
	DeviceGroupKey *string `type:"string"`

	// The device key.
	DeviceKey *string `min:"1" type:"string"`
}

// String returns the string representation
func (s NewDeviceMetadataType) String() string {
	return awsutil.Prettify(s)
}

// The notify configuration type.
type NotifyConfigurationType struct {
	_ struct{} `type:"structure"`

	// Email template used when a detected risk event is blocked.
	BlockEmail *NotifyEmailType `type:"structure"`

	// The email address that is sending the email. It must be either individually
	// verified with Amazon SES, or from a domain that has been verified with Amazon
	// SES.
	From *string `type:"string"`

	// The MFA email template used when MFA is challenged as part of a detected
	// risk.
	MfaEmail *NotifyEmailType `type:"structure"`

	// The email template used when a detected risk event is allowed.
	NoActionEmail *NotifyEmailType `type:"structure"`

	// The destination to which the receiver of an email should reply to.
	ReplyTo *string `type:"string"`

	// The Amazon Resource Name (ARN) of the identity that is associated with the
	// sending authorization policy. It permits Amazon Cognito to send for the email
	// address specified in the From parameter.
	//
	// SourceArn is a required field
	SourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s NotifyConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyConfigurationType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NotifyConfigurationType"}

	if s.SourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceArn"))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceArn", 20))
	}
	if s.BlockEmail != nil {
		if err := s.BlockEmail.Validate(); err != nil {
			invalidParams.AddNested("BlockEmail", err.(aws.ErrInvalidParams))
		}
	}
	if s.MfaEmail != nil {
		if err := s.MfaEmail.Validate(); err != nil {
			invalidParams.AddNested("MfaEmail", err.(aws.ErrInvalidParams))
		}
	}
	if s.NoActionEmail != nil {
		if err := s.NoActionEmail.Validate(); err != nil {
			invalidParams.AddNested("NoActionEmail", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The notify email type.
type NotifyEmailType struct {
	_ struct{} `type:"structure"`

	// The HTML body.
	HtmlBody *string `min:"6" type:"string"`

	// The subject.
	//
	// Subject is a required field
	Subject *string `min:"1" type:"string" required:"true"`

	// The text body.
	TextBody *string `min:"6" type:"string"`
}

// String returns the string representation
func (s NotifyEmailType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyEmailType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NotifyEmailType"}
	if s.HtmlBody != nil && len(*s.HtmlBody) < 6 {
		invalidParams.Add(aws.NewErrParamMinLen("HtmlBody", 6))
	}

	if s.Subject == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subject"))
	}
	if s.Subject != nil && len(*s.Subject) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Subject", 1))
	}
	if s.TextBody != nil && len(*s.TextBody) < 6 {
		invalidParams.Add(aws.NewErrParamMinLen("TextBody", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The minimum and maximum value of an attribute that is of the number data
// type.
type NumberAttributeConstraintsType struct {
	_ struct{} `type:"structure"`

	// The maximum value of an attribute that is of the number data type.
	MaxValue *string `type:"string"`

	// The minimum value of an attribute that is of the number data type.
	MinValue *string `type:"string"`
}

// String returns the string representation
func (s NumberAttributeConstraintsType) String() string {
	return awsutil.Prettify(s)
}

// The password policy type.
type PasswordPolicyType struct {
	_ struct{} `type:"structure"`

	// The minimum length of the password policy that you have set. Cannot be less
	// than 6.
	MinimumLength *int64 `min:"6" type:"integer"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one lowercase letter in their password.
	RequireLowercase *bool `type:"boolean"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one number in their password.
	RequireNumbers *bool `type:"boolean"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one symbol in their password.
	RequireSymbols *bool `type:"boolean"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one uppercase letter in their password.
	RequireUppercase *bool `type:"boolean"`

	// In the password policy you have set, refers to the number of days a temporary
	// password is valid. If the user does not sign-in during this time, their password
	// will need to be reset by an administrator.
	//
	// When you set TemporaryPasswordValidityDays for a user pool, you will no longer
	// be able to set the deprecated UnusedAccountValidityDays value for that user
	// pool.
	TemporaryPasswordValidityDays *int64 `type:"integer"`
}

// String returns the string representation
func (s PasswordPolicyType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PasswordPolicyType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PasswordPolicyType"}
	if s.MinimumLength != nil && *s.MinimumLength < 6 {
		invalidParams.Add(aws.NewErrParamMinValue("MinimumLength", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A container for identity provider details.
type ProviderDescription struct {
	_ struct{} `type:"structure"`

	// The date the provider was added to the user pool.
	CreationDate *time.Time `type:"timestamp"`

	// The date the provider was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The identity provider name.
	ProviderName *string `min:"1" type:"string"`

	// The identity provider type.
	ProviderType IdentityProviderTypeType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ProviderDescription) String() string {
	return awsutil.Prettify(s)
}

// A container for information about an identity provider for a user pool.
type ProviderUserIdentifierType struct {
	_ struct{} `type:"structure"`

	// The name of the provider attribute to link to, for example, NameID.
	ProviderAttributeName *string `type:"string"`

	// The value of the provider attribute to link to, for example, xxxxx_account.
	ProviderAttributeValue *string `type:"string"`

	// The name of the provider, for example, Facebook, Google, or Login with Amazon.
	ProviderName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ProviderUserIdentifierType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProviderUserIdentifierType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProviderUserIdentifierType"}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProviderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A map containing a priority as a key, and recovery method name as a value.
type RecoveryOptionType struct {
	_ struct{} `type:"structure"`

	// Specifies the recovery method for a user.
	//
	// Name is a required field
	Name RecoveryOptionNameType `type:"string" required:"true" enum:"true"`

	// A positive integer specifying priority of a method with 1 being the highest
	// priority.
	//
	// Priority is a required field
	Priority *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s RecoveryOptionType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecoveryOptionType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RecoveryOptionType"}
	if len(s.Name) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Priority == nil {
		invalidParams.Add(aws.NewErrParamRequired("Priority"))
	}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Priority", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A resource server scope.
type ResourceServerScopeType struct {
	_ struct{} `type:"structure"`

	// A description of the scope.
	//
	// ScopeDescription is a required field
	ScopeDescription *string `min:"1" type:"string" required:"true"`

	// The name of the scope.
	//
	// ScopeName is a required field
	ScopeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceServerScopeType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceServerScopeType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceServerScopeType"}

	if s.ScopeDescription == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScopeDescription"))
	}
	if s.ScopeDescription != nil && len(*s.ScopeDescription) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ScopeDescription", 1))
	}

	if s.ScopeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScopeName"))
	}
	if s.ScopeName != nil && len(*s.ScopeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ScopeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A container for information about a resource server for a user pool.
type ResourceServerType struct {
	_ struct{} `type:"structure"`

	// The identifier for the resource server.
	Identifier *string `min:"1" type:"string"`

	// The name of the resource server.
	Name *string `min:"1" type:"string"`

	// A list of scopes that are defined for the resource server.
	Scopes []ResourceServerScopeType `type:"list"`

	// The user pool ID for the user pool that hosts the resource server.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceServerType) String() string {
	return awsutil.Prettify(s)
}

// The risk configuration type.
type RiskConfigurationType struct {
	_ struct{} `type:"structure"`

	// The account takeover risk configuration object including the NotifyConfiguration
	// object and Actions to take in the case of an account takeover.
	AccountTakeoverRiskConfiguration *AccountTakeoverRiskConfigurationType `type:"structure"`

	// The app client ID.
	ClientId *string `min:"1" type:"string" sensitive:"true"`

	// The compromised credentials risk configuration object including the EventFilter
	// and the EventAction
	CompromisedCredentialsRiskConfiguration *CompromisedCredentialsRiskConfigurationType `type:"structure"`

	// The last modified date.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The configuration to override the risk decision.
	RiskExceptionConfiguration *RiskExceptionConfigurationType `type:"structure"`

	// The user pool ID.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RiskConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// The type of the configuration to override the risk decision.
type RiskExceptionConfigurationType struct {
	_ struct{} `type:"structure"`

	// Overrides the risk decision to always block the pre-authentication requests.
	// The IP range is in CIDR notation: a compact representation of an IP address
	// and its associated routing prefix.
	BlockedIPRangeList []string `type:"list"`

	// Risk detection is not performed on the IP addresses in the range list. The
	// IP range is in CIDR notation.
	SkippedIPRangeList []string `type:"list"`
}

// String returns the string representation
func (s RiskExceptionConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// The type used for enabling SMS MFA at the user level.
type SMSMfaSettingsType struct {
	_ struct{} `type:"structure"`

	// Specifies whether SMS text message MFA is enabled.
	Enabled *bool `type:"boolean"`

	// Specifies whether SMS is the preferred MFA method.
	PreferredMfa *bool `type:"boolean"`
}

// String returns the string representation
func (s SMSMfaSettingsType) String() string {
	return awsutil.Prettify(s)
}

// Contains information about the schema attribute.
type SchemaAttributeType struct {
	_ struct{} `type:"structure"`

	// The attribute data type.
	AttributeDataType AttributeDataType `type:"string" enum:"true"`

	//
	// We recommend that you use WriteAttributes (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes)
	// in the user pool client to control how attributes can be mutated for new
	// use cases instead of using DeveloperOnlyAttribute.
	//
	// Specifies whether the attribute type is developer only. This attribute can
	// only be modified by an administrator. Users will not be able to modify this
	// attribute using their access token. For example, DeveloperOnlyAttribute can
	// be modified using the API but cannot be updated using the API.
	DeveloperOnlyAttribute *bool `type:"boolean"`

	// Specifies whether the value of the attribute can be changed.
	//
	// For any user pool attribute that's mapped to an identity provider attribute,
	// you must set this parameter to true. Amazon Cognito updates mapped attributes
	// when users sign in to your application through an identity provider. If an
	// attribute is immutable, Amazon Cognito throws an error when it attempts to
	// update the attribute. For more information, see Specifying Identity Provider
	// Attribute Mappings for Your User Pool (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html).
	Mutable *bool `type:"boolean"`

	// A schema attribute of the name type.
	Name *string `min:"1" type:"string"`

	// Specifies the constraints for an attribute of the number type.
	NumberAttributeConstraints *NumberAttributeConstraintsType `type:"structure"`

	// Specifies whether a user pool attribute is required. If the attribute is
	// required and the user does not provide a value, registration or sign-in will
	// fail.
	Required *bool `type:"boolean"`

	// Specifies the constraints for an attribute of the string type.
	StringAttributeConstraints *StringAttributeConstraintsType `type:"structure"`
}

// String returns the string representation
func (s SchemaAttributeType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SchemaAttributeType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SchemaAttributeType"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The SMS configuration type that includes the settings the Cognito User Pool
// needs to call for the Amazon SNS service to send an SMS message from your
// AWS account. The Cognito User Pool makes the request to the Amazon SNS Service
// by using an AWS IAM role that you provide for your AWS account.
type SmsConfigurationType struct {
	_ struct{} `type:"structure"`

	// The external ID is a value that we recommend you use to add security to your
	// IAM role which is used to call Amazon SNS to send SMS messages for your user
	// pool. If you provide an ExternalId, the Cognito User Pool will include it
	// when attempting to assume your IAM role, so that you can set your roles trust
	// policy to require the ExternalID. If you use the Cognito Management Console
	// to create a role for SMS MFA, Cognito will create a role with the required
	// permissions and a trust policy that demonstrates use of the ExternalId.
	ExternalId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) caller. This is the ARN of the IAM role in your AWS account which Cognito
	// will use to send SMS messages.
	//
	// SnsCallerArn is a required field
	SnsCallerArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s SmsConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SmsConfigurationType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SmsConfigurationType"}

	if s.SnsCallerArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnsCallerArn"))
	}
	if s.SnsCallerArn != nil && len(*s.SnsCallerArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("SnsCallerArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The SMS text message multi-factor authentication (MFA) configuration type.
type SmsMfaConfigType struct {
	_ struct{} `type:"structure"`

	// The SMS authentication message that will be sent to users with the code they
	// need to sign in. The message must contain the ‘{####}’ placeholder, which
	// will be replaced with the code. If the message is not included, and default
	// message will be used.
	SmsAuthenticationMessage *string `min:"6" type:"string"`

	// The SMS configuration.
	SmsConfiguration *SmsConfigurationType `type:"structure"`
}

// String returns the string representation
func (s SmsMfaConfigType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SmsMfaConfigType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SmsMfaConfigType"}
	if s.SmsAuthenticationMessage != nil && len(*s.SmsAuthenticationMessage) < 6 {
		invalidParams.Add(aws.NewErrParamMinLen("SmsAuthenticationMessage", 6))
	}
	if s.SmsConfiguration != nil {
		if err := s.SmsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SmsConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The type used for enabling software token MFA at the user pool level.
type SoftwareTokenMfaConfigType struct {
	_ struct{} `type:"structure"`

	// Specifies whether software token MFA is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s SoftwareTokenMfaConfigType) String() string {
	return awsutil.Prettify(s)
}

// The type used for enabling software token MFA at the user level.
type SoftwareTokenMfaSettingsType struct {
	_ struct{} `type:"structure"`

	// Specifies whether software token MFA is enabled.
	Enabled *bool `type:"boolean"`

	// Specifies whether software token MFA is the preferred MFA method.
	PreferredMfa *bool `type:"boolean"`
}

// String returns the string representation
func (s SoftwareTokenMfaSettingsType) String() string {
	return awsutil.Prettify(s)
}

// The constraints associated with a string attribute.
type StringAttributeConstraintsType struct {
	_ struct{} `type:"structure"`

	// The maximum length.
	MaxLength *string `type:"string"`

	// The minimum length.
	MinLength *string `type:"string"`
}

// String returns the string representation
func (s StringAttributeConstraintsType) String() string {
	return awsutil.Prettify(s)
}

// A container for the UI customization information for a user pool's built-in
// app UI.
type UICustomizationType struct {
	_ struct{} `type:"structure"`

	// The CSS values in the UI customization.
	CSS *string `type:"string"`

	// The CSS version number.
	CSSVersion *string `type:"string"`

	// The client ID for the client app.
	ClientId *string `min:"1" type:"string" sensitive:"true"`

	// The creation date for the UI customization.
	CreationDate *time.Time `type:"timestamp"`

	// The logo image for the UI customization.
	ImageUrl *string `type:"string"`

	// The last-modified date for the UI customization.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The user pool ID for the user pool.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UICustomizationType) String() string {
	return awsutil.Prettify(s)
}

// Contextual data such as the user's device fingerprint, IP address, or location
// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
// security.
type UserContextDataType struct {
	_ struct{} `type:"structure"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	EncodedData *string `type:"string"`
}

// String returns the string representation
func (s UserContextDataType) String() string {
	return awsutil.Prettify(s)
}

// The user import job type.
type UserImportJobType struct {
	_ struct{} `type:"structure"`

	// The role ARN for the Amazon CloudWatch Logging role for the user import job.
	// For more information, see "Creating the CloudWatch Logs IAM Role" in the
	// Amazon Cognito Developer Guide.
	CloudWatchLogsRoleArn *string `min:"20" type:"string"`

	// The date when the user import job was completed.
	CompletionDate *time.Time `type:"timestamp"`

	// The message returned when the user import job is completed.
	CompletionMessage *string `min:"1" type:"string"`

	// The date the user import job was created.
	CreationDate *time.Time `type:"timestamp"`

	// The number of users that could not be imported.
	FailedUsers *int64 `type:"long"`

	// The number of users that were successfully imported.
	ImportedUsers *int64 `type:"long"`

	// The job ID for the user import job.
	JobId *string `min:"1" type:"string"`

	// The job name for the user import job.
	JobName *string `min:"1" type:"string"`

	// The pre-signed URL to be used to upload the .csv file.
	PreSignedUrl *string `type:"string"`

	// The number of users that were skipped.
	SkippedUsers *int64 `type:"long"`

	// The date when the user import job was started.
	StartDate *time.Time `type:"timestamp"`

	// The status of the user import job. One of the following:
	//
	//    * Created - The job was created but not started.
	//
	//    * Pending - A transition state. You have started the job, but it has not
	//    begun importing users yet.
	//
	//    * InProgress - The job has started, and users are being imported.
	//
	//    * Stopping - You have stopped the job, but the job has not stopped importing
	//    users yet.
	//
	//    * Stopped - You have stopped the job, and the job has stopped importing
	//    users.
	//
	//    * Succeeded - The job has completed successfully.
	//
	//    * Failed - The job has stopped due to an error.
	//
	//    * Expired - You created a job, but did not start the job within 24-48
	//    hours. All data associated with the job was deleted, and the job cannot
	//    be started.
	Status UserImportJobStatusType `type:"string" enum:"true"`

	// The user pool ID for the user pool that the users are being imported into.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserImportJobType) String() string {
	return awsutil.Prettify(s)
}

// The user pool add-ons type.
type UserPoolAddOnsType struct {
	_ struct{} `type:"structure"`

	// The advanced security mode.
	//
	// AdvancedSecurityMode is a required field
	AdvancedSecurityMode AdvancedSecurityModeType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UserPoolAddOnsType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserPoolAddOnsType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UserPoolAddOnsType"}
	if len(s.AdvancedSecurityMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AdvancedSecurityMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The description of the user pool client.
type UserPoolClientDescription struct {
	_ struct{} `type:"structure"`

	// The ID of the client associated with the user pool.
	ClientId *string `min:"1" type:"string" sensitive:"true"`

	// The client name from the user pool client description.
	ClientName *string `min:"1" type:"string"`

	// The user pool ID for the user pool where you want to describe the user pool
	// client.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserPoolClientDescription) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a user pool client.
type UserPoolClientType struct {
	_ struct{} `type:"structure"`

	// The allowed OAuth flows.
	//
	// Set to code to initiate a code grant flow, which provides an authorization
	// code as the response. This code can be exchanged for access tokens with the
	// token endpoint.
	//
	// Set to implicit to specify that the client should get the access token (and,
	// optionally, ID token, based on scopes) directly.
	//
	// Set to client_credentials to specify that the client should get the access
	// token (and, optionally, ID token, based on scopes) from the token endpoint
	// using a combination of client and client_secret.
	AllowedOAuthFlows []OAuthFlowType `type:"list"`

	// Set to true if the client is allowed to follow the OAuth protocol when interacting
	// with Cognito user pools.
	AllowedOAuthFlowsUserPoolClient *bool `type:"boolean"`

	// The allowed OAuth scopes. Possible values provided by OAuth are: phone, email,
	// openid, and profile. Possible values provided by AWS are: aws.cognito.signin.user.admin.
	// Custom scopes created in Resource Servers are also supported.
	AllowedOAuthScopes []string `type:"list"`

	// The Amazon Pinpoint analytics configuration for the user pool client.
	//
	// Cognito User Pools only supports sending events to Amazon Pinpoint projects
	// in the US East (N. Virginia) us-east-1 Region, regardless of the region in
	// which the user pool resides.
	AnalyticsConfiguration *AnalyticsConfigurationType `type:"structure"`

	// A list of allowed redirect (callback) URLs for the identity providers.
	//
	// A redirect URI must:
	//
	//    * Be an absolute URI.
	//
	//    * Be registered with the authorization server.
	//
	//    * Not include a fragment component.
	//
	// See OAuth 2.0 - Redirection Endpoint (https://tools.ietf.org/html/rfc6749#section-3.1.2).
	//
	// Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing
	// purposes only.
	//
	// App callback URLs such as myapp://example are also supported.
	CallbackURLs []string `type:"list"`

	// The ID of the client associated with the user pool.
	ClientId *string `min:"1" type:"string" sensitive:"true"`

	// The client name from the user pool request of the client type.
	ClientName *string `min:"1" type:"string"`

	// The client secret from the user pool request of the client type.
	ClientSecret *string `min:"1" type:"string" sensitive:"true"`

	// The date the user pool client was created.
	CreationDate *time.Time `type:"timestamp"`

	// The default redirect URI. Must be in the CallbackURLs list.
	//
	// A redirect URI must:
	//
	//    * Be an absolute URI.
	//
	//    * Be registered with the authorization server.
	//
	//    * Not include a fragment component.
	//
	// See OAuth 2.0 - Redirection Endpoint (https://tools.ietf.org/html/rfc6749#section-3.1.2).
	//
	// Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing
	// purposes only.
	//
	// App callback URLs such as myapp://example are also supported.
	DefaultRedirectURI *string `min:"1" type:"string"`

	// The authentication flows that are supported by the user pool clients. Flow
	// names without the ALLOW_ prefix are deprecated in favor of new names with
	// the ALLOW_ prefix. Note that values with ALLOW_ prefix cannot be used along
	// with values without ALLOW_ prefix.
	//
	// Valid values include:
	//
	//    * ALLOW_ADMIN_USER_PASSWORD_AUTH: Enable admin based user password authentication
	//    flow ADMIN_USER_PASSWORD_AUTH. This setting replaces the ADMIN_NO_SRP_AUTH
	//    setting. With this authentication flow, Cognito receives the password
	//    in the request instead of using the SRP (Secure Remote Password protocol)
	//    protocol to verify passwords.
	//
	//    * ALLOW_CUSTOM_AUTH: Enable Lambda trigger based authentication.
	//
	//    * ALLOW_USER_PASSWORD_AUTH: Enable user password-based authentication.
	//    In this flow, Cognito receives the password in the request instead of
	//    using the SRP protocol to verify passwords.
	//
	//    * ALLOW_USER_SRP_AUTH: Enable SRP based authentication.
	//
	//    * ALLOW_REFRESH_TOKEN_AUTH: Enable authflow to refresh tokens.
	ExplicitAuthFlows []ExplicitAuthFlowsType `type:"list"`

	// The date the user pool client was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// A list of allowed logout URLs for the identity providers.
	LogoutURLs []string `type:"list"`

	// Use this setting to choose which errors and responses are returned by Cognito
	// APIs during authentication, account confirmation, and password recovery when
	// the user does not exist in the user pool. When set to ENABLED and the user
	// does not exist, authentication returns an error indicating either the username
	// or password was incorrect, and account confirmation and password recovery
	// return a response indicating a code was sent to a simulated destination.
	// When set to LEGACY, those APIs will return a UserNotFoundException exception
	// if the user does not exist in the user pool.
	//
	// Valid values include:
	//
	//    * ENABLED - This prevents user existence-related errors.
	//
	//    * LEGACY - This represents the old behavior of Cognito where user existence
	//    related errors are not prevented.
	//
	// This setting affects the behavior of following APIs:
	//
	//    * AdminInitiateAuth
	//
	//    * AdminRespondToAuthChallenge
	//
	//    * InitiateAuth
	//
	//    * RespondToAuthChallenge
	//
	//    * ForgotPassword
	//
	//    * ConfirmForgotPassword
	//
	//    * ConfirmSignUp
	//
	//    * ResendConfirmationCode
	//
	// After February 15th 2020, the value of PreventUserExistenceErrors will default
	// to ENABLED for newly created user pool clients if no value is provided.
	PreventUserExistenceErrors PreventUserExistenceErrorTypes `type:"string" enum:"true"`

	// The Read-only attributes.
	ReadAttributes []string `type:"list"`

	// The time limit, in days, after which the refresh token is no longer valid
	// and cannot be used.
	RefreshTokenValidity *int64 `type:"integer"`

	// A list of provider names for the identity providers that are supported on
	// this client.
	SupportedIdentityProviders []string `type:"list"`

	// The user pool ID for the user pool client.
	UserPoolId *string `min:"1" type:"string"`

	// The writeable attributes.
	WriteAttributes []string `type:"list"`
}

// String returns the string representation
func (s UserPoolClientType) String() string {
	return awsutil.Prettify(s)
}

// A user pool description.
type UserPoolDescriptionType struct {
	_ struct{} `type:"structure"`

	// The date the user pool description was created.
	CreationDate *time.Time `type:"timestamp"`

	// The ID in a user pool description.
	Id *string `min:"1" type:"string"`

	// The AWS Lambda configuration information in a user pool description.
	LambdaConfig *LambdaConfigType `type:"structure"`

	// The date the user pool description was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The name in a user pool description.
	Name *string `min:"1" type:"string"`

	// The user pool status in a user pool description.
	Status StatusType `type:"string" enum:"true"`
}

// String returns the string representation
func (s UserPoolDescriptionType) String() string {
	return awsutil.Prettify(s)
}

// The policy associated with a user pool.
type UserPoolPolicyType struct {
	_ struct{} `type:"structure"`

	// The password policy.
	PasswordPolicy *PasswordPolicyType `type:"structure"`
}

// String returns the string representation
func (s UserPoolPolicyType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserPoolPolicyType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UserPoolPolicyType"}
	if s.PasswordPolicy != nil {
		if err := s.PasswordPolicy.Validate(); err != nil {
			invalidParams.AddNested("PasswordPolicy", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A container for information about the user pool.
type UserPoolType struct {
	_ struct{} `type:"structure"`

	// Use this setting to define which verified available method a user can use
	// to recover their password when they call ForgotPassword. It allows you to
	// define a preferred method when a user has more than one method available.
	// With this setting, SMS does not qualify for a valid password recovery mechanism
	// if the user also has SMS MFA enabled. In the absence of this setting, Cognito
	// uses the legacy behavior to determine the recovery method where SMS is preferred
	// over email.
	AccountRecoverySetting *AccountRecoverySettingType `type:"structure"`

	// The configuration for AdminCreateUser requests.
	AdminCreateUserConfig *AdminCreateUserConfigType `type:"structure"`

	// Specifies the attributes that are aliased in a user pool.
	AliasAttributes []AliasAttributeType `type:"list"`

	// The Amazon Resource Name (ARN) for the user pool.
	Arn *string `min:"20" type:"string"`

	// Specifies the attributes that are auto-verified in a user pool.
	AutoVerifiedAttributes []VerifiedAttributeType `type:"list"`

	// The date the user pool was created.
	CreationDate *time.Time `type:"timestamp"`

	// A custom domain name that you provide to Amazon Cognito. This parameter applies
	// only if you use a custom domain to host the sign-up and sign-in pages for
	// your application. For example: auth.example.com.
	//
	// For more information about adding a custom domain to your user pool, see
	// Using Your Own Domain for the Hosted UI (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html).
	CustomDomain *string `min:"1" type:"string"`

	// The device configuration.
	DeviceConfiguration *DeviceConfigurationType `type:"structure"`

	// Holds the domain prefix if the user pool has a domain associated with it.
	Domain *string `min:"1" type:"string"`

	// The email configuration.
	EmailConfiguration *EmailConfigurationType `type:"structure"`

	// The reason why the email configuration cannot send the messages to your users.
	EmailConfigurationFailure *string `type:"string"`

	// The contents of the email verification message.
	EmailVerificationMessage *string `min:"6" type:"string"`

	// The subject of the email verification message.
	EmailVerificationSubject *string `min:"1" type:"string"`

	// A number estimating the size of the user pool.
	EstimatedNumberOfUsers *int64 `type:"integer"`

	// The ID of the user pool.
	Id *string `min:"1" type:"string"`

	// The AWS Lambda triggers associated with the user pool.
	LambdaConfig *LambdaConfigType `type:"structure"`

	// The date the user pool was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// Can be one of the following values:
	//
	//    * OFF - MFA tokens are not required and cannot be specified during user
	//    registration.
	//
	//    * ON - MFA tokens are required for all user registrations. You can only
	//    specify required when you are initially creating a user pool.
	//
	//    * OPTIONAL - Users have the option when registering to create an MFA token.
	MfaConfiguration UserPoolMfaType `type:"string" enum:"true"`

	// The name of the user pool.
	Name *string `min:"1" type:"string"`

	// The policies associated with the user pool.
	Policies *UserPoolPolicyType `type:"structure"`

	// A container with the schema attributes of a user pool.
	SchemaAttributes []SchemaAttributeType `min:"1" type:"list"`

	// The contents of the SMS authentication message.
	SmsAuthenticationMessage *string `min:"6" type:"string"`

	// The SMS configuration.
	SmsConfiguration *SmsConfigurationType `type:"structure"`

	// The reason why the SMS configuration cannot send the messages to your users.
	SmsConfigurationFailure *string `type:"string"`

	// The contents of the SMS verification message.
	SmsVerificationMessage *string `min:"6" type:"string"`

	// The status of a user pool.
	Status StatusType `type:"string" enum:"true"`

	// The user pool add-ons.
	UserPoolAddOns *UserPoolAddOnsType `type:"structure"`

	// The tags that are assigned to the user pool. A tag is a label that you can
	// apply to user pools to categorize and manage them in different ways, such
	// as by purpose, owner, environment, or other criteria.
	UserPoolTags map[string]string `type:"map"`

	// Specifies whether email addresses or phone numbers can be specified as usernames
	// when a user signs up.
	UsernameAttributes []UsernameAttributeType `type:"list"`

	// You can choose to enable case sensitivity on the username input for the selected
	// sign-in option. For example, when this is set to False, users will be able
	// to sign in using either "username" or "Username". This configuration is immutable
	// once it has been set. For more information, see .
	UsernameConfiguration *UsernameConfigurationType `type:"structure"`

	// The template for verification messages.
	VerificationMessageTemplate *VerificationMessageTemplateType `type:"structure"`
}

// String returns the string representation
func (s UserPoolType) String() string {
	return awsutil.Prettify(s)
}

// The user type.
type UserType struct {
	_ struct{} `type:"structure"`

	// A container with information about the user type attributes.
	Attributes []AttributeType `type:"list"`

	// Specifies whether the user is enabled.
	Enabled *bool `type:"boolean"`

	// The MFA options for the user.
	MFAOptions []MFAOptionType `type:"list"`

	// The creation date of the user.
	UserCreateDate *time.Time `type:"timestamp"`

	// The last modified date of the user.
	UserLastModifiedDate *time.Time `type:"timestamp"`

	// The user status. Can be one of the following:
	//
	//    * UNCONFIRMED - User has been created but not confirmed.
	//
	//    * CONFIRMED - User has been confirmed.
	//
	//    * ARCHIVED - User is no longer active.
	//
	//    * COMPROMISED - User is disabled due to a potential security threat.
	//
	//    * UNKNOWN - User status is not known.
	//
	//    * RESET_REQUIRED - User is confirmed, but the user must request a code
	//    and reset his or her password before he or she can sign in.
	//
	//    * FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign
	//    in using a temporary password, but on first sign-in, the user must change
	//    his or her password to a new value before doing anything else.
	UserStatus UserStatusType `type:"string" enum:"true"`

	// The user name of the user you wish to describe.
	Username *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s UserType) String() string {
	return awsutil.Prettify(s)
}

// The username configuration type.
type UsernameConfigurationType struct {
	_ struct{} `type:"structure"`

	// Specifies whether username case sensitivity will be applied for all users
	// in the user pool through Cognito APIs.
	//
	// Valid values include:
	//
	//    * True : Enables case sensitivity for all username input. When this option
	//    is set to True, users must sign in using the exact capitalization of their
	//    given username. For example, “UserName”. This is the default value.
	//
	//    * False : Enables case insensitivity for all username input. For example,
	//    when this option is set to False, users will be able to sign in using
	//    either "username" or "Username". This option also enables both preferred_username
	//    and email alias to be case insensitive, in addition to the username attribute.
	//
	// CaseSensitive is a required field
	CaseSensitive *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s UsernameConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UsernameConfigurationType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UsernameConfigurationType"}

	if s.CaseSensitive == nil {
		invalidParams.Add(aws.NewErrParamRequired("CaseSensitive"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The template for verification messages.
type VerificationMessageTemplateType struct {
	_ struct{} `type:"structure"`

	// The default email option.
	DefaultEmailOption DefaultEmailOptionType `type:"string" enum:"true"`

	// The email message template.
	EmailMessage *string `min:"6" type:"string"`

	// The email message template for sending a confirmation link to the user.
	EmailMessageByLink *string `min:"6" type:"string"`

	// The subject line for the email message template.
	EmailSubject *string `min:"1" type:"string"`

	// The subject line for the email message template for sending a confirmation
	// link to the user.
	EmailSubjectByLink *string `min:"1" type:"string"`

	// The SMS message template.
	SmsMessage *string `min:"6" type:"string"`
}

// String returns the string representation
func (s VerificationMessageTemplateType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerificationMessageTemplateType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VerificationMessageTemplateType"}
	if s.EmailMessage != nil && len(*s.EmailMessage) < 6 {
		invalidParams.Add(aws.NewErrParamMinLen("EmailMessage", 6))
	}
	if s.EmailMessageByLink != nil && len(*s.EmailMessageByLink) < 6 {
		invalidParams.Add(aws.NewErrParamMinLen("EmailMessageByLink", 6))
	}
	if s.EmailSubject != nil && len(*s.EmailSubject) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EmailSubject", 1))
	}
	if s.EmailSubjectByLink != nil && len(*s.EmailSubjectByLink) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EmailSubjectByLink", 1))
	}
	if s.SmsMessage != nil && len(*s.SmsMessage) < 6 {
		invalidParams.Add(aws.NewErrParamMinLen("SmsMessage", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
