// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteEntityRecognizerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	//
	// EntityRecognizerArn is a required field
	EntityRecognizerArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEntityRecognizerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEntityRecognizerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteEntityRecognizerInput"}

	if s.EntityRecognizerArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("EntityRecognizerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteEntityRecognizerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEntityRecognizerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteEntityRecognizer = "DeleteEntityRecognizer"

// DeleteEntityRecognizerRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Deletes an entity recognizer.
//
// Only those recognizers that are in terminated states (IN_ERROR, TRAINED)
// will be deleted. If an active inference job is using the model, a ResourceInUseException
// will be returned.
//
// This is an asynchronous action that puts the recognizer into a DELETING state,
// and it is then removed by a background job. Once removed, the recognizer
// disappears from your account and is no longer available for use.
//
//    // Example sending a request using DeleteEntityRecognizerRequest.
//    req := client.DeleteEntityRecognizerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEntityRecognizer
func (c *Client) DeleteEntityRecognizerRequest(input *DeleteEntityRecognizerInput) DeleteEntityRecognizerRequest {
	op := &aws.Operation{
		Name:       opDeleteEntityRecognizer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEntityRecognizerInput{}
	}

	req := c.newRequest(op, input, &DeleteEntityRecognizerOutput{})

	return DeleteEntityRecognizerRequest{Request: req, Input: input, Copy: c.DeleteEntityRecognizerRequest}
}

// DeleteEntityRecognizerRequest is the request type for the
// DeleteEntityRecognizer API operation.
type DeleteEntityRecognizerRequest struct {
	*aws.Request
	Input *DeleteEntityRecognizerInput
	Copy  func(*DeleteEntityRecognizerInput) DeleteEntityRecognizerRequest
}

// Send marshals and sends the DeleteEntityRecognizer API request.
func (r DeleteEntityRecognizerRequest) Send(ctx context.Context) (*DeleteEntityRecognizerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteEntityRecognizerResponse{
		DeleteEntityRecognizerOutput: r.Request.Data.(*DeleteEntityRecognizerOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteEntityRecognizerResponse is the response type for the
// DeleteEntityRecognizer API operation.
type DeleteEntityRecognizerResponse struct {
	*DeleteEntityRecognizerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteEntityRecognizer request.
func (r *DeleteEntityRecognizerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
