// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DetectKeyPhrasesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode LanguageCode `type:"string" required:"true" enum:"true"`

	// A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8
	// encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s DetectKeyPhrasesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectKeyPhrasesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetectKeyPhrasesInput"}
	if len(s.LanguageCode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("LanguageCode"))
	}

	if s.Text == nil {
		invalidParams.Add(aws.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DetectKeyPhrasesOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A collection of key phrases that Amazon Comprehend identified in the input
	// text. For each key phrase, the response provides the text of the key phrase,
	// where the key phrase begins and ends, and the level of confidence that Amazon
	// Comprehend has in the accuracy of the detection.
	KeyPhrases []KeyPhrase `type:"list"`
}

// String returns the string representation
func (s DetectKeyPhrasesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDetectKeyPhrases = "DetectKeyPhrases"

// DetectKeyPhrasesRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Detects the key noun phrases found in the text.
//
//    // Example sending a request using DetectKeyPhrasesRequest.
//    req := client.DetectKeyPhrasesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases
func (c *Client) DetectKeyPhrasesRequest(input *DetectKeyPhrasesInput) DetectKeyPhrasesRequest {
	op := &aws.Operation{
		Name:       opDetectKeyPhrases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectKeyPhrasesInput{}
	}

	req := c.newRequest(op, input, &DetectKeyPhrasesOutput{})

	return DetectKeyPhrasesRequest{Request: req, Input: input, Copy: c.DetectKeyPhrasesRequest}
}

// DetectKeyPhrasesRequest is the request type for the
// DetectKeyPhrases API operation.
type DetectKeyPhrasesRequest struct {
	*aws.Request
	Input *DetectKeyPhrasesInput
	Copy  func(*DetectKeyPhrasesInput) DetectKeyPhrasesRequest
}

// Send marshals and sends the DetectKeyPhrases API request.
func (r DetectKeyPhrasesRequest) Send(ctx context.Context) (*DetectKeyPhrasesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetectKeyPhrasesResponse{
		DetectKeyPhrasesOutput: r.Request.Data.(*DetectKeyPhrasesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetectKeyPhrasesResponse is the response type for the
// DetectKeyPhrases API operation.
type DetectKeyPhrasesResponse struct {
	*DetectKeyPhrasesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetectKeyPhrases request.
func (r *DetectKeyPhrasesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
