// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehendmedical

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeICD10CMInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend Medical generated for the job. The
	// StartICD10CMInferenceJob operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeICD10CMInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeICD10CMInferenceJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeICD10CMInferenceJobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeICD10CMInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a detection job.
	ComprehendMedicalAsyncJobProperties *ComprehendMedicalAsyncJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeICD10CMInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeICD10CMInferenceJob = "DescribeICD10CMInferenceJob"

// DescribeICD10CMInferenceJobRequest returns a request value for making API operation for
// AWS Comprehend Medical.
//
// Gets the properties associated with an InferICD10CM job. Use this operation
// to get the status of an inference job.
//
//    // Example sending a request using DescribeICD10CMInferenceJobRequest.
//    req := client.DescribeICD10CMInferenceJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeICD10CMInferenceJob
func (c *Client) DescribeICD10CMInferenceJobRequest(input *DescribeICD10CMInferenceJobInput) DescribeICD10CMInferenceJobRequest {
	op := &aws.Operation{
		Name:       opDescribeICD10CMInferenceJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeICD10CMInferenceJobInput{}
	}

	req := c.newRequest(op, input, &DescribeICD10CMInferenceJobOutput{})

	return DescribeICD10CMInferenceJobRequest{Request: req, Input: input, Copy: c.DescribeICD10CMInferenceJobRequest}
}

// DescribeICD10CMInferenceJobRequest is the request type for the
// DescribeICD10CMInferenceJob API operation.
type DescribeICD10CMInferenceJobRequest struct {
	*aws.Request
	Input *DescribeICD10CMInferenceJobInput
	Copy  func(*DescribeICD10CMInferenceJobInput) DescribeICD10CMInferenceJobRequest
}

// Send marshals and sends the DescribeICD10CMInferenceJob API request.
func (r DescribeICD10CMInferenceJobRequest) Send(ctx context.Context) (*DescribeICD10CMInferenceJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeICD10CMInferenceJobResponse{
		DescribeICD10CMInferenceJobOutput: r.Request.Data.(*DescribeICD10CMInferenceJobOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeICD10CMInferenceJobResponse is the response type for the
// DescribeICD10CMInferenceJob API operation.
type DescribeICD10CMInferenceJobResponse struct {
	*DescribeICD10CMInferenceJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeICD10CMInferenceJob request.
func (r *DescribeICD10CMInferenceJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
