// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehendmedical

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribePHIDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend Medical generated for the job. The
	// StartPHIDetectionJob operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePHIDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePHIDetectionJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribePHIDetectionJobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribePHIDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a detection job.
	ComprehendMedicalAsyncJobProperties *ComprehendMedicalAsyncJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribePHIDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribePHIDetectionJob = "DescribePHIDetectionJob"

// DescribePHIDetectionJobRequest returns a request value for making API operation for
// AWS Comprehend Medical.
//
// Gets the properties associated with a protected health information (PHI)
// detection job. Use this operation to get the status of a detection job.
//
//    // Example sending a request using DescribePHIDetectionJobRequest.
//    req := client.DescribePHIDetectionJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribePHIDetectionJob
func (c *Client) DescribePHIDetectionJobRequest(input *DescribePHIDetectionJobInput) DescribePHIDetectionJobRequest {
	op := &aws.Operation{
		Name:       opDescribePHIDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePHIDetectionJobInput{}
	}

	req := c.newRequest(op, input, &DescribePHIDetectionJobOutput{})

	return DescribePHIDetectionJobRequest{Request: req, Input: input, Copy: c.DescribePHIDetectionJobRequest}
}

// DescribePHIDetectionJobRequest is the request type for the
// DescribePHIDetectionJob API operation.
type DescribePHIDetectionJobRequest struct {
	*aws.Request
	Input *DescribePHIDetectionJobInput
	Copy  func(*DescribePHIDetectionJobInput) DescribePHIDetectionJobRequest
}

// Send marshals and sends the DescribePHIDetectionJob API request.
func (r DescribePHIDetectionJobRequest) Send(ctx context.Context) (*DescribePHIDetectionJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribePHIDetectionJobResponse{
		DescribePHIDetectionJobOutput: r.Request.Data.(*DescribePHIDetectionJobOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribePHIDetectionJobResponse is the response type for the
// DescribePHIDetectionJob API operation.
type DescribePHIDetectionJobResponse struct {
	*DescribePHIDetectionJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribePHIDetectionJob request.
func (r *DescribePHIDetectionJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
