// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehendmedical

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeRxNormInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend Medical generated for the job. The
	// StartRxNormInferenceJob operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRxNormInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRxNormInferenceJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeRxNormInferenceJobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeRxNormInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a detection job.
	ComprehendMedicalAsyncJobProperties *ComprehendMedicalAsyncJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeRxNormInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeRxNormInferenceJob = "DescribeRxNormInferenceJob"

// DescribeRxNormInferenceJobRequest returns a request value for making API operation for
// AWS Comprehend Medical.
//
// Gets the properties associated with an InferRxNorm job. Use this operation
// to get the status of an inference job.
//
//    // Example sending a request using DescribeRxNormInferenceJobRequest.
//    req := client.DescribeRxNormInferenceJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeRxNormInferenceJob
func (c *Client) DescribeRxNormInferenceJobRequest(input *DescribeRxNormInferenceJobInput) DescribeRxNormInferenceJobRequest {
	op := &aws.Operation{
		Name:       opDescribeRxNormInferenceJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRxNormInferenceJobInput{}
	}

	req := c.newRequest(op, input, &DescribeRxNormInferenceJobOutput{})

	return DescribeRxNormInferenceJobRequest{Request: req, Input: input, Copy: c.DescribeRxNormInferenceJobRequest}
}

// DescribeRxNormInferenceJobRequest is the request type for the
// DescribeRxNormInferenceJob API operation.
type DescribeRxNormInferenceJobRequest struct {
	*aws.Request
	Input *DescribeRxNormInferenceJobInput
	Copy  func(*DescribeRxNormInferenceJobInput) DescribeRxNormInferenceJobRequest
}

// Send marshals and sends the DescribeRxNormInferenceJob API request.
func (r DescribeRxNormInferenceJobRequest) Send(ctx context.Context) (*DescribeRxNormInferenceJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeRxNormInferenceJobResponse{
		DescribeRxNormInferenceJobOutput: r.Request.Data.(*DescribeRxNormInferenceJobOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeRxNormInferenceJobResponse is the response type for the
// DescribeRxNormInferenceJob API operation.
type DescribeRxNormInferenceJobResponse struct {
	*DescribeRxNormInferenceJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeRxNormInferenceJob request.
func (r *DescribeRxNormInferenceJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
