// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehendmedical

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DetectPHIInput struct {
	_ struct{} `type:"structure"`

	// A UTF-8 text string containing the clinical content being examined for PHI
	// entities. Each string must contain fewer than 20,000 bytes of characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectPHIInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectPHIInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetectPHIInput"}

	if s.Text == nil {
		invalidParams.Add(aws.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DetectPHIOutput struct {
	_ struct{} `type:"structure"`

	// The collection of PHI entities extracted from the input text and their associated
	// information. For each entity, the response provides the entity text, the
	// entity category, where the entity text begins and ends, and the level of
	// confidence that Amazon Comprehend Medical has in its detection.
	//
	// Entities is a required field
	Entities []Entity `type:"list" required:"true"`

	// The version of the model used to analyze the documents. The version number
	// looks like X.X.X. You can use this information to track the model used for
	// a particular batch of documents.
	//
	// ModelVersion is a required field
	ModelVersion *string `min:"1" type:"string" required:"true"`

	// If the result of the previous request to DetectPHI was truncated, include
	// the PaginationToken to fetch the next page of PHI entities.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DetectPHIOutput) String() string {
	return awsutil.Prettify(s)
}

const opDetectPHI = "DetectPHI"

// DetectPHIRequest returns a request value for making API operation for
// AWS Comprehend Medical.
//
// Inspects the clinical text for protected health information (PHI) entities
// and returns the entity category, location, and confidence score for each
// entity. Amazon Comprehend Medical only detects entities in English language
// texts.
//
//    // Example sending a request using DetectPHIRequest.
//    req := client.DetectPHIRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectPHI
func (c *Client) DetectPHIRequest(input *DetectPHIInput) DetectPHIRequest {
	op := &aws.Operation{
		Name:       opDetectPHI,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectPHIInput{}
	}

	req := c.newRequest(op, input, &DetectPHIOutput{})

	return DetectPHIRequest{Request: req, Input: input, Copy: c.DetectPHIRequest}
}

// DetectPHIRequest is the request type for the
// DetectPHI API operation.
type DetectPHIRequest struct {
	*aws.Request
	Input *DetectPHIInput
	Copy  func(*DetectPHIInput) DetectPHIRequest
}

// Send marshals and sends the DetectPHI API request.
func (r DetectPHIRequest) Send(ctx context.Context) (*DetectPHIResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetectPHIResponse{
		DetectPHIOutput: r.Request.Data.(*DetectPHIOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetectPHIResponse is the response type for the
// DetectPHI API operation.
type DetectPHIResponse struct {
	*DetectPHIOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetectPHI request.
func (r *DetectPHIResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
