// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehendmedical

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListPHIDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs based on their names,
	// status, or the date and time that they were submitted. You can only set one
	// filter at a time.
	Filter *ComprehendMedicalAsyncJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListPHIDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPHIDetectionJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPHIDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListPHIDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job returned.
	ComprehendMedicalAsyncJobPropertiesList []ComprehendMedicalAsyncJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListPHIDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListPHIDetectionJobs = "ListPHIDetectionJobs"

// ListPHIDetectionJobsRequest returns a request value for making API operation for
// AWS Comprehend Medical.
//
// Gets a list of protected health information (PHI) detection jobs that you
// have submitted.
//
//    // Example sending a request using ListPHIDetectionJobsRequest.
//    req := client.ListPHIDetectionJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListPHIDetectionJobs
func (c *Client) ListPHIDetectionJobsRequest(input *ListPHIDetectionJobsInput) ListPHIDetectionJobsRequest {
	op := &aws.Operation{
		Name:       opListPHIDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPHIDetectionJobsInput{}
	}

	req := c.newRequest(op, input, &ListPHIDetectionJobsOutput{})

	return ListPHIDetectionJobsRequest{Request: req, Input: input, Copy: c.ListPHIDetectionJobsRequest}
}

// ListPHIDetectionJobsRequest is the request type for the
// ListPHIDetectionJobs API operation.
type ListPHIDetectionJobsRequest struct {
	*aws.Request
	Input *ListPHIDetectionJobsInput
	Copy  func(*ListPHIDetectionJobsInput) ListPHIDetectionJobsRequest
}

// Send marshals and sends the ListPHIDetectionJobs API request.
func (r ListPHIDetectionJobsRequest) Send(ctx context.Context) (*ListPHIDetectionJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPHIDetectionJobsResponse{
		ListPHIDetectionJobsOutput: r.Request.Data.(*ListPHIDetectionJobsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListPHIDetectionJobsResponse is the response type for the
// ListPHIDetectionJobs API operation.
type ListPHIDetectionJobsResponse struct {
	*ListPHIDetectionJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPHIDetectionJobs request.
func (r *ListPHIDetectionJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
