// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehendmedical

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopICD10CMInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopICD10CMInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopICD10CMInferenceJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopICD10CMInferenceJobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopICD10CMInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of job, use this
	// identifier with the DescribeICD10CMInferenceJob operation.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StopICD10CMInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopICD10CMInferenceJob = "StopICD10CMInferenceJob"

// StopICD10CMInferenceJobRequest returns a request value for making API operation for
// AWS Comprehend Medical.
//
// Stops an InferICD10CM inference job in progress.
//
//    // Example sending a request using StopICD10CMInferenceJobRequest.
//    req := client.StopICD10CMInferenceJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopICD10CMInferenceJob
func (c *Client) StopICD10CMInferenceJobRequest(input *StopICD10CMInferenceJobInput) StopICD10CMInferenceJobRequest {
	op := &aws.Operation{
		Name:       opStopICD10CMInferenceJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopICD10CMInferenceJobInput{}
	}

	req := c.newRequest(op, input, &StopICD10CMInferenceJobOutput{})

	return StopICD10CMInferenceJobRequest{Request: req, Input: input, Copy: c.StopICD10CMInferenceJobRequest}
}

// StopICD10CMInferenceJobRequest is the request type for the
// StopICD10CMInferenceJob API operation.
type StopICD10CMInferenceJobRequest struct {
	*aws.Request
	Input *StopICD10CMInferenceJobInput
	Copy  func(*StopICD10CMInferenceJobInput) StopICD10CMInferenceJobRequest
}

// Send marshals and sends the StopICD10CMInferenceJob API request.
func (r StopICD10CMInferenceJobRequest) Send(ctx context.Context) (*StopICD10CMInferenceJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopICD10CMInferenceJobResponse{
		StopICD10CMInferenceJobOutput: r.Request.Data.(*StopICD10CMInferenceJobOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopICD10CMInferenceJobResponse is the response type for the
// StopICD10CMInferenceJob API operation.
type StopICD10CMInferenceJobResponse struct {
	*StopICD10CMInferenceJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopICD10CMInferenceJob request.
func (r *StopICD10CMInferenceJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
