// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package computeoptimizer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeRecommendationExportJobsInput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe a filter to return a more specific list
	// of export jobs.
	Filters []JobFilter `locationName:"filters" type:"list"`

	// The identification numbers of the export jobs to return.
	//
	// An export job ID is returned when you create an export using the ExportAutoScalingGroupRecommendations
	// or ExportEC2InstanceRecommendations actions.
	//
	// All export jobs created in the last seven days are returned if this parameter
	// is omitted.
	JobIds []string `locationName:"jobIds" type:"list"`

	// The maximum number of export jobs to return with a single request.
	//
	// To retrieve the remaining results, make another request with the returned
	// NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to advance to the next page of export jobs.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeRecommendationExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeRecommendationExportJobsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to advance to the next page of export jobs.
	//
	// This value is null when there are no more pages of export jobs to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that describe recommendation export jobs.
	RecommendationExportJobs []RecommendationExportJob `locationName:"recommendationExportJobs" type:"list"`
}

// String returns the string representation
func (s DescribeRecommendationExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeRecommendationExportJobs = "DescribeRecommendationExportJobs"

// DescribeRecommendationExportJobsRequest returns a request value for making API operation for
// AWS Compute Optimizer.
//
// Describes recommendation export jobs created in the last seven days.
//
// Use the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations
// actions to request an export of your recommendations. Then use the DescribeRecommendationExportJobs
// action to view your export jobs.
//
//    // Example sending a request using DescribeRecommendationExportJobsRequest.
//    req := client.DescribeRecommendationExportJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/DescribeRecommendationExportJobs
func (c *Client) DescribeRecommendationExportJobsRequest(input *DescribeRecommendationExportJobsInput) DescribeRecommendationExportJobsRequest {
	op := &aws.Operation{
		Name:       opDescribeRecommendationExportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRecommendationExportJobsInput{}
	}

	req := c.newRequest(op, input, &DescribeRecommendationExportJobsOutput{})

	return DescribeRecommendationExportJobsRequest{Request: req, Input: input, Copy: c.DescribeRecommendationExportJobsRequest}
}

// DescribeRecommendationExportJobsRequest is the request type for the
// DescribeRecommendationExportJobs API operation.
type DescribeRecommendationExportJobsRequest struct {
	*aws.Request
	Input *DescribeRecommendationExportJobsInput
	Copy  func(*DescribeRecommendationExportJobsInput) DescribeRecommendationExportJobsRequest
}

// Send marshals and sends the DescribeRecommendationExportJobs API request.
func (r DescribeRecommendationExportJobsRequest) Send(ctx context.Context) (*DescribeRecommendationExportJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeRecommendationExportJobsResponse{
		DescribeRecommendationExportJobsOutput: r.Request.Data.(*DescribeRecommendationExportJobsOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeRecommendationExportJobsResponse is the response type for the
// DescribeRecommendationExportJobs API operation.
type DescribeRecommendationExportJobsResponse struct {
	*DescribeRecommendationExportJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeRecommendationExportJobs request.
func (r *DescribeRecommendationExportJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
