// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package computeoptimizer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ExportAutoScalingGroupRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the AWS accounts for which to export Auto Scaling group recommendations.
	//
	// If your account is the master account of an organization, use this parameter
	// to specify the member accounts for which you want to export recommendations.
	//
	// This parameter cannot be specified together with the include member accounts
	// parameter. The parameters are mutually exclusive.
	//
	// Recommendations for member accounts are not included in the export if this
	// parameter, or the include member accounts parameter, is omitted.
	//
	// You can specify multiple account IDs per request.
	AccountIds []string `locationName:"accountIds" type:"list"`

	// The recommendations data to include in the export file.
	FieldsToExport []ExportableAutoScalingGroupField `locationName:"fieldsToExport" type:"list"`

	// The format of the export file.
	//
	// The only export file format currently supported is Csv.
	FileFormat FileFormat `locationName:"fileFormat" type:"string" enum:"true"`

	// An array of objects that describe a filter to export a more specific set
	// of Auto Scaling group recommendations.
	Filters []Filter `locationName:"filters" type:"list"`

	// Indicates whether to include recommendations for resources in all member
	// accounts of the organization if your account is the master account of an
	// organization.
	//
	// The member accounts must also be opted in to Compute Optimizer.
	//
	// Recommendations for member accounts of the organization are not included
	// in the export file if this parameter is omitted.
	//
	// This parameter cannot be specified together with the account IDs parameter.
	// The parameters are mutually exclusive.
	//
	// Recommendations for member accounts are not included in the export if this
	// parameter, or the account IDs parameter, is omitted.
	IncludeMemberAccounts *bool `locationName:"includeMemberAccounts" type:"boolean"`

	// An object to specify the destination Amazon Simple Storage Service (Amazon
	// S3) bucket name and key prefix for the export job.
	//
	// You must create the destination Amazon S3 bucket for your recommendations
	// export before you create the export job. Compute Optimizer does not create
	// the S3 bucket for you. After you create the S3 bucket, ensure that it has
	// the required permission policy to allow Compute Optimizer to write the export
	// file to it. If you plan to specify an object prefix when you create the export
	// job, you must include the object prefix in the policy that you add to the
	// S3 bucket. For more information, see Amazon S3 Bucket Policy for Compute
	// Optimizer (https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html)
	// in the Compute Optimizer user guide.
	//
	// S3DestinationConfig is a required field
	S3DestinationConfig *S3DestinationConfig `locationName:"s3DestinationConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s ExportAutoScalingGroupRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportAutoScalingGroupRecommendationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExportAutoScalingGroupRecommendationsInput"}

	if s.S3DestinationConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3DestinationConfig"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ExportAutoScalingGroupRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The identification number of the export job.
	//
	// Use the DescribeRecommendationExportJobs action, and specify the job ID to
	// view the status of an export job.
	JobId *string `locationName:"jobId" type:"string"`

	// An object that describes the destination Amazon S3 bucket of a recommendations
	// export file.
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure"`
}

// String returns the string representation
func (s ExportAutoScalingGroupRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opExportAutoScalingGroupRecommendations = "ExportAutoScalingGroupRecommendations"

// ExportAutoScalingGroupRecommendationsRequest returns a request value for making API operation for
// AWS Compute Optimizer.
//
// Exports optimization recommendations for Auto Scaling groups.
//
// Recommendations are exported in a comma-separated values (.csv) file, and
// its metadata in a JavaScript Object Notation (.json) file, to an existing
// Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more
// information, see Exporting Recommendations (https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html)
// in the Compute Optimizer User Guide.
//
// You can have only one Auto Scaling group export job in progress per AWS Region.
//
//    // Example sending a request using ExportAutoScalingGroupRecommendationsRequest.
//    req := client.ExportAutoScalingGroupRecommendationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportAutoScalingGroupRecommendations
func (c *Client) ExportAutoScalingGroupRecommendationsRequest(input *ExportAutoScalingGroupRecommendationsInput) ExportAutoScalingGroupRecommendationsRequest {
	op := &aws.Operation{
		Name:       opExportAutoScalingGroupRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExportAutoScalingGroupRecommendationsInput{}
	}

	req := c.newRequest(op, input, &ExportAutoScalingGroupRecommendationsOutput{})

	return ExportAutoScalingGroupRecommendationsRequest{Request: req, Input: input, Copy: c.ExportAutoScalingGroupRecommendationsRequest}
}

// ExportAutoScalingGroupRecommendationsRequest is the request type for the
// ExportAutoScalingGroupRecommendations API operation.
type ExportAutoScalingGroupRecommendationsRequest struct {
	*aws.Request
	Input *ExportAutoScalingGroupRecommendationsInput
	Copy  func(*ExportAutoScalingGroupRecommendationsInput) ExportAutoScalingGroupRecommendationsRequest
}

// Send marshals and sends the ExportAutoScalingGroupRecommendations API request.
func (r ExportAutoScalingGroupRecommendationsRequest) Send(ctx context.Context) (*ExportAutoScalingGroupRecommendationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ExportAutoScalingGroupRecommendationsResponse{
		ExportAutoScalingGroupRecommendationsOutput: r.Request.Data.(*ExportAutoScalingGroupRecommendationsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ExportAutoScalingGroupRecommendationsResponse is the response type for the
// ExportAutoScalingGroupRecommendations API operation.
type ExportAutoScalingGroupRecommendationsResponse struct {
	*ExportAutoScalingGroupRecommendationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ExportAutoScalingGroupRecommendations request.
func (r *ExportAutoScalingGroupRecommendationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
