// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package computeoptimizer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ExportEC2InstanceRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the AWS accounts for which to export instance recommendations.
	//
	// If your account is the master account of an organization, use this parameter
	// to specify the member accounts for which you want to export recommendations.
	//
	// This parameter cannot be specified together with the include member accounts
	// parameter. The parameters are mutually exclusive.
	//
	// Recommendations for member accounts are not included in the export if this
	// parameter, or the include member accounts parameter, is omitted.
	//
	// You can specify multiple account IDs per request.
	AccountIds []string `locationName:"accountIds" type:"list"`

	// The recommendations data to include in the export file.
	FieldsToExport []ExportableInstanceField `locationName:"fieldsToExport" type:"list"`

	// The format of the export file.
	//
	// The only export file format currently supported is Csv.
	FileFormat FileFormat `locationName:"fileFormat" type:"string" enum:"true"`

	// An array of objects that describe a filter to export a more specific set
	// of instance recommendations.
	Filters []Filter `locationName:"filters" type:"list"`

	// Indicates whether to include recommendations for resources in all member
	// accounts of the organization if your account is the master account of an
	// organization.
	//
	// The member accounts must also be opted in to Compute Optimizer.
	//
	// Recommendations for member accounts of the organization are not included
	// in the export file if this parameter is omitted.
	//
	// Recommendations for member accounts are not included in the export if this
	// parameter, or the account IDs parameter, is omitted.
	IncludeMemberAccounts *bool `locationName:"includeMemberAccounts" type:"boolean"`

	// An object to specify the destination Amazon Simple Storage Service (Amazon
	// S3) bucket name and key prefix for the export job.
	//
	// You must create the destination Amazon S3 bucket for your recommendations
	// export before you create the export job. Compute Optimizer does not create
	// the S3 bucket for you. After you create the S3 bucket, ensure that it has
	// the required permission policy to allow Compute Optimizer to write the export
	// file to it. If you plan to specify an object prefix when you create the export
	// job, you must include the object prefix in the policy that you add to the
	// S3 bucket. For more information, see Amazon S3 Bucket Policy for Compute
	// Optimizer (https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html)
	// in the Compute Optimizer user guide.
	//
	// S3DestinationConfig is a required field
	S3DestinationConfig *S3DestinationConfig `locationName:"s3DestinationConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s ExportEC2InstanceRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportEC2InstanceRecommendationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExportEC2InstanceRecommendationsInput"}

	if s.S3DestinationConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3DestinationConfig"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ExportEC2InstanceRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The identification number of the export job.
	//
	// Use the DescribeRecommendationExportJobs action, and specify the job ID to
	// view the status of an export job.
	JobId *string `locationName:"jobId" type:"string"`

	// An object that describes the destination Amazon S3 bucket of a recommendations
	// export file.
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure"`
}

// String returns the string representation
func (s ExportEC2InstanceRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opExportEC2InstanceRecommendations = "ExportEC2InstanceRecommendations"

// ExportEC2InstanceRecommendationsRequest returns a request value for making API operation for
// AWS Compute Optimizer.
//
// Exports optimization recommendations for Amazon EC2 instances.
//
// Recommendations are exported in a comma-separated values (.csv) file, and
// its metadata in a JavaScript Object Notation (.json) file, to an existing
// Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more
// information, see Exporting Recommendations (https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html)
// in the Compute Optimizer User Guide.
//
// You can have only one Amazon EC2 instance export job in progress per AWS
// Region.
//
//    // Example sending a request using ExportEC2InstanceRecommendationsRequest.
//    req := client.ExportEC2InstanceRecommendationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportEC2InstanceRecommendations
func (c *Client) ExportEC2InstanceRecommendationsRequest(input *ExportEC2InstanceRecommendationsInput) ExportEC2InstanceRecommendationsRequest {
	op := &aws.Operation{
		Name:       opExportEC2InstanceRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExportEC2InstanceRecommendationsInput{}
	}

	req := c.newRequest(op, input, &ExportEC2InstanceRecommendationsOutput{})

	return ExportEC2InstanceRecommendationsRequest{Request: req, Input: input, Copy: c.ExportEC2InstanceRecommendationsRequest}
}

// ExportEC2InstanceRecommendationsRequest is the request type for the
// ExportEC2InstanceRecommendations API operation.
type ExportEC2InstanceRecommendationsRequest struct {
	*aws.Request
	Input *ExportEC2InstanceRecommendationsInput
	Copy  func(*ExportEC2InstanceRecommendationsInput) ExportEC2InstanceRecommendationsRequest
}

// Send marshals and sends the ExportEC2InstanceRecommendations API request.
func (r ExportEC2InstanceRecommendationsRequest) Send(ctx context.Context) (*ExportEC2InstanceRecommendationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ExportEC2InstanceRecommendationsResponse{
		ExportEC2InstanceRecommendationsOutput: r.Request.Data.(*ExportEC2InstanceRecommendationsOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ExportEC2InstanceRecommendationsResponse is the response type for the
// ExportEC2InstanceRecommendations API operation.
type ExportEC2InstanceRecommendationsResponse struct {
	*ExportEC2InstanceRecommendationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ExportEC2InstanceRecommendations request.
func (r *ExportEC2InstanceRecommendationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
