// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package computeoptimizer

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetEC2RecommendationProjectedMetricsInput struct {
	_ struct{} `type:"structure"`

	// The time stamp of the last projected metrics data point to return.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the instances for which to return recommendation
	// projected metrics.
	//
	// InstanceArn is a required field
	InstanceArn *string `locationName:"instanceArn" type:"string" required:"true"`

	// The granularity, in seconds, of the projected metrics data points.
	//
	// Period is a required field
	Period *int64 `locationName:"period" type:"integer" required:"true"`

	// The time stamp of the first projected metrics data point to return.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The statistic of the projected metrics.
	//
	// Stat is a required field
	Stat MetricStatistic `locationName:"stat" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GetEC2RecommendationProjectedMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEC2RecommendationProjectedMetricsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetEC2RecommendationProjectedMetricsInput"}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}

	if s.InstanceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceArn"))
	}

	if s.Period == nil {
		invalidParams.Add(aws.NewErrParamRequired("Period"))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}
	if len(s.Stat) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Stat"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetEC2RecommendationProjectedMetricsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe a projected metrics.
	RecommendedOptionProjectedMetrics []RecommendedOptionProjectedMetric `locationName:"recommendedOptionProjectedMetrics" type:"list"`
}

// String returns the string representation
func (s GetEC2RecommendationProjectedMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetEC2RecommendationProjectedMetrics = "GetEC2RecommendationProjectedMetrics"

// GetEC2RecommendationProjectedMetricsRequest returns a request value for making API operation for
// AWS Compute Optimizer.
//
// Returns the projected utilization metrics of Amazon EC2 instance recommendations.
//
//    // Example sending a request using GetEC2RecommendationProjectedMetricsRequest.
//    req := client.GetEC2RecommendationProjectedMetricsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEC2RecommendationProjectedMetrics
func (c *Client) GetEC2RecommendationProjectedMetricsRequest(input *GetEC2RecommendationProjectedMetricsInput) GetEC2RecommendationProjectedMetricsRequest {
	op := &aws.Operation{
		Name:       opGetEC2RecommendationProjectedMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEC2RecommendationProjectedMetricsInput{}
	}

	req := c.newRequest(op, input, &GetEC2RecommendationProjectedMetricsOutput{})

	return GetEC2RecommendationProjectedMetricsRequest{Request: req, Input: input, Copy: c.GetEC2RecommendationProjectedMetricsRequest}
}

// GetEC2RecommendationProjectedMetricsRequest is the request type for the
// GetEC2RecommendationProjectedMetrics API operation.
type GetEC2RecommendationProjectedMetricsRequest struct {
	*aws.Request
	Input *GetEC2RecommendationProjectedMetricsInput
	Copy  func(*GetEC2RecommendationProjectedMetricsInput) GetEC2RecommendationProjectedMetricsRequest
}

// Send marshals and sends the GetEC2RecommendationProjectedMetrics API request.
func (r GetEC2RecommendationProjectedMetricsRequest) Send(ctx context.Context) (*GetEC2RecommendationProjectedMetricsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetEC2RecommendationProjectedMetricsResponse{
		GetEC2RecommendationProjectedMetricsOutput: r.Request.Data.(*GetEC2RecommendationProjectedMetricsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetEC2RecommendationProjectedMetricsResponse is the response type for the
// GetEC2RecommendationProjectedMetrics API operation.
type GetEC2RecommendationProjectedMetricsResponse struct {
	*GetEC2RecommendationProjectedMetricsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetEC2RecommendationProjectedMetrics request.
func (r *GetEC2RecommendationProjectedMetricsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
