// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package computeoptimizeriface provides an interface to enable mocking the AWS Compute Optimizer service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package computeoptimizeriface

import (
	"github.com/aws/aws-sdk-go-v2/service/computeoptimizer"
)

// ClientAPI provides an interface to enable mocking the
// computeoptimizer.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Compute Optimizer.
//    func myFunc(svc computeoptimizeriface.ClientAPI) bool {
//        // Make svc.DescribeRecommendationExportJobs request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := computeoptimizer.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        computeoptimizeriface.ClientPI
//    }
//    func (m *mockClientClient) DescribeRecommendationExportJobs(input *computeoptimizer.DescribeRecommendationExportJobsInput) (*computeoptimizer.DescribeRecommendationExportJobsOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	DescribeRecommendationExportJobsRequest(*computeoptimizer.DescribeRecommendationExportJobsInput) computeoptimizer.DescribeRecommendationExportJobsRequest

	ExportAutoScalingGroupRecommendationsRequest(*computeoptimizer.ExportAutoScalingGroupRecommendationsInput) computeoptimizer.ExportAutoScalingGroupRecommendationsRequest

	ExportEC2InstanceRecommendationsRequest(*computeoptimizer.ExportEC2InstanceRecommendationsInput) computeoptimizer.ExportEC2InstanceRecommendationsRequest

	GetAutoScalingGroupRecommendationsRequest(*computeoptimizer.GetAutoScalingGroupRecommendationsInput) computeoptimizer.GetAutoScalingGroupRecommendationsRequest

	GetEC2InstanceRecommendationsRequest(*computeoptimizer.GetEC2InstanceRecommendationsInput) computeoptimizer.GetEC2InstanceRecommendationsRequest

	GetEC2RecommendationProjectedMetricsRequest(*computeoptimizer.GetEC2RecommendationProjectedMetricsInput) computeoptimizer.GetEC2RecommendationProjectedMetricsRequest

	GetEnrollmentStatusRequest(*computeoptimizer.GetEnrollmentStatusInput) computeoptimizer.GetEnrollmentStatusRequest

	GetRecommendationSummariesRequest(*computeoptimizer.GetRecommendationSummariesInput) computeoptimizer.GetRecommendationSummariesRequest

	UpdateEnrollmentStatusRequest(*computeoptimizer.UpdateEnrollmentStatusInput) computeoptimizer.UpdateEnrollmentStatusRequest
}

var _ ClientAPI = (*computeoptimizer.Client)(nil)
