// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteRetentionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the retention configuration to delete.
	//
	// RetentionConfigurationName is a required field
	RetentionConfigurationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRetentionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRetentionConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRetentionConfigurationInput"}

	if s.RetentionConfigurationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RetentionConfigurationName"))
	}
	if s.RetentionConfigurationName != nil && len(*s.RetentionConfigurationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RetentionConfigurationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteRetentionConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRetentionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteRetentionConfiguration = "DeleteRetentionConfiguration"

// DeleteRetentionConfigurationRequest returns a request value for making API operation for
// AWS Config.
//
// Deletes the retention configuration.
//
//    // Example sending a request using DeleteRetentionConfigurationRequest.
//    req := client.DeleteRetentionConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration
func (c *Client) DeleteRetentionConfigurationRequest(input *DeleteRetentionConfigurationInput) DeleteRetentionConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteRetentionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRetentionConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteRetentionConfigurationOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteRetentionConfigurationRequest{Request: req, Input: input, Copy: c.DeleteRetentionConfigurationRequest}
}

// DeleteRetentionConfigurationRequest is the request type for the
// DeleteRetentionConfiguration API operation.
type DeleteRetentionConfigurationRequest struct {
	*aws.Request
	Input *DeleteRetentionConfigurationInput
	Copy  func(*DeleteRetentionConfigurationInput) DeleteRetentionConfigurationRequest
}

// Send marshals and sends the DeleteRetentionConfiguration API request.
func (r DeleteRetentionConfigurationRequest) Send(ctx context.Context) (*DeleteRetentionConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRetentionConfigurationResponse{
		DeleteRetentionConfigurationOutput: r.Request.Data.(*DeleteRetentionConfigurationOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRetentionConfigurationResponse is the response type for the
// DeleteRetentionConfiguration API operation.
type DeleteRetentionConfigurationResponse struct {
	*DeleteRetentionConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRetentionConfiguration request.
func (r *DeleteRetentionConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
