// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeConfigRulesInput struct {
	_ struct{} `type:"structure"`

	// The names of the AWS Config rules for which you want details. If you do not
	// specify any names, AWS Config returns details for all your rules.
	ConfigRuleNames []string `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigRulesInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeConfigRulesOutput struct {
	_ struct{} `type:"structure"`

	// The details about your AWS Config rules.
	ConfigRules []ConfigRule `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigRulesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeConfigRules = "DescribeConfigRules"

// DescribeConfigRulesRequest returns a request value for making API operation for
// AWS Config.
//
// Returns details about your AWS Config rules.
//
//    // Example sending a request using DescribeConfigRulesRequest.
//    req := client.DescribeConfigRulesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules
func (c *Client) DescribeConfigRulesRequest(input *DescribeConfigRulesInput) DescribeConfigRulesRequest {
	op := &aws.Operation{
		Name:       opDescribeConfigRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigRulesInput{}
	}

	req := c.newRequest(op, input, &DescribeConfigRulesOutput{})

	return DescribeConfigRulesRequest{Request: req, Input: input, Copy: c.DescribeConfigRulesRequest}
}

// DescribeConfigRulesRequest is the request type for the
// DescribeConfigRules API operation.
type DescribeConfigRulesRequest struct {
	*aws.Request
	Input *DescribeConfigRulesInput
	Copy  func(*DescribeConfigRulesInput) DescribeConfigRulesRequest
}

// Send marshals and sends the DescribeConfigRules API request.
func (r DescribeConfigRulesRequest) Send(ctx context.Context) (*DescribeConfigRulesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeConfigRulesResponse{
		DescribeConfigRulesOutput: r.Request.Data.(*DescribeConfigRulesOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeConfigRulesResponse is the response type for the
// DescribeConfigRules API operation.
type DescribeConfigRulesResponse struct {
	*DescribeConfigRulesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeConfigRules request.
func (r *DescribeConfigRulesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
