// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeOrganizationConfigRuleStatusesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of OrganizationConfigRuleStatuses returned on each page.
	// If you do no specify a number, AWS Config uses the default. The default is
	// 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The names of organization config rules for which you want status details.
	// If you do not specify any names, AWS Config returns details for all your
	// organization AWS Confg rules.
	OrganizationConfigRuleNames []string `type:"list"`
}

// String returns the string representation
func (s DescribeOrganizationConfigRuleStatusesInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeOrganizationConfigRuleStatusesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of OrganizationConfigRuleStatus objects.
	OrganizationConfigRuleStatuses []OrganizationConfigRuleStatus `type:"list"`
}

// String returns the string representation
func (s DescribeOrganizationConfigRuleStatusesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeOrganizationConfigRuleStatuses = "DescribeOrganizationConfigRuleStatuses"

// DescribeOrganizationConfigRuleStatusesRequest returns a request value for making API operation for
// AWS Config.
//
// Provides organization config rule deployment status for an organization.
//
// The status is not considered successful until organization config rule is
// successfully deployed in all the member accounts with an exception of excluded
// accounts.
//
// When you specify the limit and the next token, you receive a paginated response.
// Limit and next token are not applicable if you specify organization config
// rule names. It is only applicable, when you request all the organization
// config rules.
//
// Only a master account can call this API.
//
//    // Example sending a request using DescribeOrganizationConfigRuleStatusesRequest.
//    req := client.DescribeOrganizationConfigRuleStatusesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses
func (c *Client) DescribeOrganizationConfigRuleStatusesRequest(input *DescribeOrganizationConfigRuleStatusesInput) DescribeOrganizationConfigRuleStatusesRequest {
	op := &aws.Operation{
		Name:       opDescribeOrganizationConfigRuleStatuses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrganizationConfigRuleStatusesInput{}
	}

	req := c.newRequest(op, input, &DescribeOrganizationConfigRuleStatusesOutput{})

	return DescribeOrganizationConfigRuleStatusesRequest{Request: req, Input: input, Copy: c.DescribeOrganizationConfigRuleStatusesRequest}
}

// DescribeOrganizationConfigRuleStatusesRequest is the request type for the
// DescribeOrganizationConfigRuleStatuses API operation.
type DescribeOrganizationConfigRuleStatusesRequest struct {
	*aws.Request
	Input *DescribeOrganizationConfigRuleStatusesInput
	Copy  func(*DescribeOrganizationConfigRuleStatusesInput) DescribeOrganizationConfigRuleStatusesRequest
}

// Send marshals and sends the DescribeOrganizationConfigRuleStatuses API request.
func (r DescribeOrganizationConfigRuleStatusesRequest) Send(ctx context.Context) (*DescribeOrganizationConfigRuleStatusesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeOrganizationConfigRuleStatusesResponse{
		DescribeOrganizationConfigRuleStatusesOutput: r.Request.Data.(*DescribeOrganizationConfigRuleStatusesOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeOrganizationConfigRuleStatusesResponse is the response type for the
// DescribeOrganizationConfigRuleStatuses API operation.
type DescribeOrganizationConfigRuleStatusesResponse struct {
	*DescribeOrganizationConfigRuleStatusesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeOrganizationConfigRuleStatuses request.
func (r *DescribeOrganizationConfigRuleStatusesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
