// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListPhoneNumbersInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximimum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ISO country code.
	PhoneNumberCountryCodes []PhoneNumberCountryCode `location:"querystring" locationName:"phoneNumberCountryCodes" type:"list"`

	// The type of phone number.
	PhoneNumberTypes []PhoneNumberType `location:"querystring" locationName:"phoneNumberTypes" type:"list"`
}

// String returns the string representation
func (s ListPhoneNumbersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPhoneNumbersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPhoneNumbersInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPhoneNumbersInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PhoneNumberCountryCodes != nil {
		v := s.PhoneNumberCountryCodes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "phoneNumberCountryCodes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.PhoneNumberTypes != nil {
		v := s.PhoneNumberTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "phoneNumberTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

type ListPhoneNumbersOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `type:"string"`

	// Information about the phone numbers.
	PhoneNumberSummaryList []PhoneNumberSummary `type:"list"`
}

// String returns the string representation
func (s ListPhoneNumbersOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPhoneNumbersOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PhoneNumberSummaryList != nil {
		v := s.PhoneNumberSummaryList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "PhoneNumberSummaryList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListPhoneNumbers = "ListPhoneNumbers"

// ListPhoneNumbersRequest returns a request value for making API operation for
// Amazon Connect Service.
//
// Provides information about the phone numbers for the specified Amazon Connect
// instance.
//
//    // Example sending a request using ListPhoneNumbersRequest.
//    req := client.ListPhoneNumbersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbers
func (c *Client) ListPhoneNumbersRequest(input *ListPhoneNumbersInput) ListPhoneNumbersRequest {
	op := &aws.Operation{
		Name:       opListPhoneNumbers,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-numbers-summary/{InstanceId}",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPhoneNumbersInput{}
	}

	req := c.newRequest(op, input, &ListPhoneNumbersOutput{})

	return ListPhoneNumbersRequest{Request: req, Input: input, Copy: c.ListPhoneNumbersRequest}
}

// ListPhoneNumbersRequest is the request type for the
// ListPhoneNumbers API operation.
type ListPhoneNumbersRequest struct {
	*aws.Request
	Input *ListPhoneNumbersInput
	Copy  func(*ListPhoneNumbersInput) ListPhoneNumbersRequest
}

// Send marshals and sends the ListPhoneNumbers API request.
func (r ListPhoneNumbersRequest) Send(ctx context.Context) (*ListPhoneNumbersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPhoneNumbersResponse{
		ListPhoneNumbersOutput: r.Request.Data.(*ListPhoneNumbersOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPhoneNumbersRequestPaginator returns a paginator for ListPhoneNumbers.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPhoneNumbersRequest(input)
//   p := connect.NewListPhoneNumbersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPhoneNumbersPaginator(req ListPhoneNumbersRequest) ListPhoneNumbersPaginator {
	return ListPhoneNumbersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPhoneNumbersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPhoneNumbersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPhoneNumbersPaginator struct {
	aws.Pager
}

func (p *ListPhoneNumbersPaginator) CurrentPage() *ListPhoneNumbersOutput {
	return p.Pager.CurrentPage().(*ListPhoneNumbersOutput)
}

// ListPhoneNumbersResponse is the response type for the
// ListPhoneNumbers API operation.
type ListPhoneNumbersResponse struct {
	*ListPhoneNumbersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPhoneNumbers request.
func (r *ListPhoneNumbersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
