// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StartContactRecordingInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the contact.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// The identifier of the contact. This is the identifier of the contact associated
	// with the first interaction with the contact center.
	//
	// InitialContactId is a required field
	InitialContactId *string `min:"1" type:"string" required:"true"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// Who is being recorded.
	//
	// VoiceRecordingConfiguration is a required field
	VoiceRecordingConfiguration *VoiceRecordingConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartContactRecordingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartContactRecordingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartContactRecordingInput"}

	if s.ContactId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContactId", 1))
	}

	if s.InitialContactId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InitialContactId"))
	}
	if s.InitialContactId != nil && len(*s.InitialContactId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InitialContactId", 1))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}

	if s.VoiceRecordingConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceRecordingConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartContactRecordingInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ContactId != nil {
		v := *s.ContactId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContactId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InitialContactId != nil {
		v := *s.InitialContactId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InitialContactId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VoiceRecordingConfiguration != nil {
		v := s.VoiceRecordingConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VoiceRecordingConfiguration", v, metadata)
	}
	return nil
}

type StartContactRecordingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartContactRecordingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartContactRecordingOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opStartContactRecording = "StartContactRecording"

// StartContactRecordingRequest returns a request value for making API operation for
// Amazon Connect Service.
//
// This API starts recording the contact when the agent joins the call. StartContactRecording
// is a one-time action. For example, if you use StopContactRecording to stop
// recording an ongoing call, you can't use StartContactRecording to restart
// it. For scenarios where the recording has started and you want to suspend
// and resume it, such as when collecting sensitive information (for example,
// a credit card number), use SuspendContactRecording and ResumeContactRecording.
//
// You can use this API to override the recording behavior configured in the
// Set recording behavior (https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html)
// block.
//
// Only voice recordings are supported at this time.
//
//    // Example sending a request using StartContactRecordingRequest.
//    req := client.StartContactRecordingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartContactRecording
func (c *Client) StartContactRecordingRequest(input *StartContactRecordingInput) StartContactRecordingRequest {
	op := &aws.Operation{
		Name:       opStartContactRecording,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/start-recording",
	}

	if input == nil {
		input = &StartContactRecordingInput{}
	}

	req := c.newRequest(op, input, &StartContactRecordingOutput{})

	return StartContactRecordingRequest{Request: req, Input: input, Copy: c.StartContactRecordingRequest}
}

// StartContactRecordingRequest is the request type for the
// StartContactRecording API operation.
type StartContactRecordingRequest struct {
	*aws.Request
	Input *StartContactRecordingInput
	Copy  func(*StartContactRecordingInput) StartContactRecordingRequest
}

// Send marshals and sends the StartContactRecording API request.
func (r StartContactRecordingRequest) Send(ctx context.Context) (*StartContactRecordingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartContactRecordingResponse{
		StartContactRecordingOutput: r.Request.Data.(*StartContactRecordingOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartContactRecordingResponse is the response type for the
// StartContactRecording API operation.
type StartContactRecordingResponse struct {
	*StartContactRecordingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartContactRecording request.
func (r *StartContactRecordingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
