// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connectparticipant

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DisconnectParticipantInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The authentication token associated with the participant's connection.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisconnectParticipantInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisconnectParticipantInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisconnectParticipantInput"}

	if s.ConnectionToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConnectionToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisconnectParticipantInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConnectionToken != nil {
		v := *s.ConnectionToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "X-Amz-Bearer", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DisconnectParticipantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisconnectParticipantOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisconnectParticipantOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDisconnectParticipant = "DisconnectParticipant"

// DisconnectParticipantRequest returns a request value for making API operation for
// Amazon Connect Participant Service.
//
// Disconnects a participant. Note that ConnectionToken is used for invoking
// this API instead of ParticipantToken.
//
//    // Example sending a request using DisconnectParticipantRequest.
//    req := client.DisconnectParticipantRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/DisconnectParticipant
func (c *Client) DisconnectParticipantRequest(input *DisconnectParticipantInput) DisconnectParticipantRequest {
	op := &aws.Operation{
		Name:       opDisconnectParticipant,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/disconnect",
	}

	if input == nil {
		input = &DisconnectParticipantInput{}
	}

	req := c.newRequest(op, input, &DisconnectParticipantOutput{})

	return DisconnectParticipantRequest{Request: req, Input: input, Copy: c.DisconnectParticipantRequest}
}

// DisconnectParticipantRequest is the request type for the
// DisconnectParticipant API operation.
type DisconnectParticipantRequest struct {
	*aws.Request
	Input *DisconnectParticipantInput
	Copy  func(*DisconnectParticipantInput) DisconnectParticipantRequest
}

// Send marshals and sends the DisconnectParticipant API request.
func (r DisconnectParticipantRequest) Send(ctx context.Context) (*DisconnectParticipantResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisconnectParticipantResponse{
		DisconnectParticipantOutput: r.Request.Data.(*DisconnectParticipantOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisconnectParticipantResponse is the response type for the
// DisconnectParticipant API operation.
type DisconnectParticipantResponse struct {
	*DisconnectParticipantOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisconnectParticipant request.
func (r *DisconnectParticipantResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
