// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connectparticipant

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type SendEventInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The authentication token associated with the participant's connection.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`

	// The content of the event to be sent (for example, message text). This is
	// not yet supported.
	Content *string `min:"1" type:"string"`

	// The content type of the request. Supported types are:
	//
	//    * application/vnd.amazonaws.connect.event.typing
	//
	//    * application/vnd.amazonaws.connect.event.connection.acknowledged
	//
	// ContentType is a required field
	ContentType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SendEventInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendEventInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SendEventInput"}

	if s.ConnectionToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConnectionToken", 1))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Content", 1))
	}

	if s.ContentType == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContentType"))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SendEventInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Content != nil {
		v := *s.Content

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Content", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConnectionToken != nil {
		v := *s.ConnectionToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "X-Amz-Bearer", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type SendEventOutput struct {
	_ struct{} `type:"structure"`

	// The time when the event was sent.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	AbsoluteTime *string `min:"1" type:"string"`

	// The ID of the response.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SendEventOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SendEventOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AbsoluteTime != nil {
		v := *s.AbsoluteTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AbsoluteTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opSendEvent = "SendEvent"

// SendEventRequest returns a request value for making API operation for
// Amazon Connect Participant Service.
//
// Sends an event. Note that ConnectionToken is used for invoking this API instead
// of ParticipantToken.
//
//    // Example sending a request using SendEventRequest.
//    req := client.SendEventRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/SendEvent
func (c *Client) SendEventRequest(input *SendEventInput) SendEventRequest {
	op := &aws.Operation{
		Name:       opSendEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/event",
	}

	if input == nil {
		input = &SendEventInput{}
	}

	req := c.newRequest(op, input, &SendEventOutput{})

	return SendEventRequest{Request: req, Input: input, Copy: c.SendEventRequest}
}

// SendEventRequest is the request type for the
// SendEvent API operation.
type SendEventRequest struct {
	*aws.Request
	Input *SendEventInput
	Copy  func(*SendEventInput) SendEventRequest
}

// Send marshals and sends the SendEvent API request.
func (r SendEventRequest) Send(ctx context.Context) (*SendEventResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SendEventResponse{
		SendEventOutput: r.Request.Data.(*SendEventOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SendEventResponse is the response type for the
// SendEvent API operation.
type SendEventResponse struct {
	*SendEventOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SendEvent request.
func (r *SendEventResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
