// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costandusagereportservice_test

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/costandusagereportservice"
)

var _ aws.Config

// To delete the AWS Cost and Usage report named ExampleReport.
//
// The following example deletes the AWS Cost and Usage report named ExampleReport.
func ExampleClient_DeleteReportDefinitionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := costandusagereportservice.New(cfg)
	input := &costandusagereportservice.DeleteReportDefinitionInput{
		ReportName: aws.String("ExampleReport"),
	}

	req := svc.DeleteReportDefinitionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case costandusagereportservice.ErrCodeInternalErrorException:
				fmt.Println(costandusagereportservice.ErrCodeInternalErrorException, aerr.Error())
			case costandusagereportservice.ErrCodeValidationException:
				fmt.Println(costandusagereportservice.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the AWS Cost and Usage reports for the account.
//
// The following example lists the AWS Cost and Usage reports for the account.
func ExampleClient_DescribeReportDefinitionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := costandusagereportservice.New(cfg)
	input := &costandusagereportservice.DescribeReportDefinitionsInput{
		MaxResults: aws.Int64(5),
	}

	req := svc.DescribeReportDefinitionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case costandusagereportservice.ErrCodeInternalErrorException:
				fmt.Println(costandusagereportservice.ErrCodeInternalErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a report named ExampleReport.
//
// The following example creates a AWS Cost and Usage report named ExampleReport.
func ExampleClient_PutReportDefinitionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := costandusagereportservice.New(cfg)
	input := &costandusagereportservice.PutReportDefinitionInput{
		ReportDefinition: &costandusagereportservice.ReportDefinition{
			AdditionalArtifacts: []costandusagereportservice.AdditionalArtifact{
				costandusagereportservice.AdditionalArtifactRedshift,
				costandusagereportservice.AdditionalArtifactQuicksight,
			},
			AdditionalSchemaElements: []costandusagereportservice.SchemaElement{
				costandusagereportservice.SchemaElementResources,
			},
			Compression: costandusagereportservice.CompressionFormatZip,
			Format:      costandusagereportservice.ReportFormatTextOrcsv,
			ReportName:  aws.String("ExampleReport"),
			S3Bucket:    aws.String("example-s3-bucket"),
			S3Prefix:    aws.String("exampleprefix"),
			S3Region:    costandusagereportservice.AWSRegionUsEast1,
			TimeUnit:    costandusagereportservice.TimeUnitDaily,
		},
	}

	req := svc.PutReportDefinitionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case costandusagereportservice.ErrCodeDuplicateReportNameException:
				fmt.Println(costandusagereportservice.ErrCodeDuplicateReportNameException, aerr.Error())
			case costandusagereportservice.ErrCodeReportLimitReachedException:
				fmt.Println(costandusagereportservice.ErrCodeReportLimitReachedException, aerr.Error())
			case costandusagereportservice.ErrCodeInternalErrorException:
				fmt.Println(costandusagereportservice.ErrCodeInternalErrorException, aerr.Error())
			case costandusagereportservice.ErrCodeValidationException:
				fmt.Println(costandusagereportservice.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
