// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costandusagereportservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyReportDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The definition of AWS Cost and Usage Report. You can specify the report name,
	// time unit, report format, compression format, S3 bucket, additional artifacts,
	// and schema elements in the definition.
	//
	// ReportDefinition is a required field
	ReportDefinition *ReportDefinition `type:"structure" required:"true"`

	// The name of the report that you want to create. The name must be unique,
	// is case sensitive, and can't include spaces.
	//
	// ReportName is a required field
	ReportName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyReportDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyReportDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyReportDefinitionInput"}

	if s.ReportDefinition == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReportDefinition"))
	}

	if s.ReportName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReportName"))
	}
	if s.ReportDefinition != nil {
		if err := s.ReportDefinition.Validate(); err != nil {
			invalidParams.AddNested("ReportDefinition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyReportDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyReportDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyReportDefinition = "ModifyReportDefinition"

// ModifyReportDefinitionRequest returns a request value for making API operation for
// AWS Cost and Usage Report Service.
//
// Allows you to programatically update your report preferences.
//
//    // Example sending a request using ModifyReportDefinitionRequest.
//    req := client.ModifyReportDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/ModifyReportDefinition
func (c *Client) ModifyReportDefinitionRequest(input *ModifyReportDefinitionInput) ModifyReportDefinitionRequest {
	op := &aws.Operation{
		Name:       opModifyReportDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReportDefinitionInput{}
	}

	req := c.newRequest(op, input, &ModifyReportDefinitionOutput{})

	return ModifyReportDefinitionRequest{Request: req, Input: input, Copy: c.ModifyReportDefinitionRequest}
}

// ModifyReportDefinitionRequest is the request type for the
// ModifyReportDefinition API operation.
type ModifyReportDefinitionRequest struct {
	*aws.Request
	Input *ModifyReportDefinitionInput
	Copy  func(*ModifyReportDefinitionInput) ModifyReportDefinitionRequest
}

// Send marshals and sends the ModifyReportDefinition API request.
func (r ModifyReportDefinitionRequest) Send(ctx context.Context) (*ModifyReportDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyReportDefinitionResponse{
		ModifyReportDefinitionOutput: r.Request.Data.(*ModifyReportDefinitionOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyReportDefinitionResponse is the response type for the
// ModifyReportDefinition API operation.
type ModifyReportDefinitionResponse struct {
	*ModifyReportDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyReportDefinition request.
func (r *ModifyReportDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
