// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costexplorer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetCostAndUsageWithResourcesInput struct {
	_ struct{} `type:"structure"`

	// Filters Amazon Web Services costs by different dimensions. For example, you
	// can specify SERVICE and LINKED_ACCOUNT and get the costs that are associated
	// with that account's usage of that service. You can nest Expression objects
	// to define any combination of dimension filters. For more information, see
	// Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html).
	//
	// The GetCostAndUsageWithResources operation requires that you either group
	// by or filter by a ResourceId.
	Filter *Expression `type:"structure"`

	// Sets the AWS cost granularity to MONTHLY, DAILY, or HOURLY. If Granularity
	// isn't set, the response object doesn't include the Granularity, MONTHLY,
	// DAILY, or HOURLY.
	Granularity Granularity `type:"string" enum:"true"`

	// You can group Amazon Web Services costs using up to two different groups:
	// either dimensions, tag keys, or both.
	GroupBy []GroupDefinition `type:"list"`

	// Which metrics are returned in the query. For more information about blended
	// and unblended rates, see Why does the "blended" annotation appear on some
	// line items in my bill? (http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/).
	//
	// Valid values are AmortizedCost, BlendedCost, NetAmortizedCost, NetUnblendedCost,
	// NormalizedUsageAmount, UnblendedCost, and UsageQuantity.
	//
	// If you return the UsageQuantity metric, the service aggregates all usage
	// numbers without taking the units into account. For example, if you aggregate
	// usageQuantity across all of Amazon EC2, the results aren't meaningful because
	// Amazon EC2 compute hours and data transfer are measured in different units
	// (for example, hours vs. GB). To get more meaningful UsageQuantity metrics,
	// filter by UsageType or UsageTypeGroups.
	//
	// Metrics is required for GetCostAndUsageWithResources requests.
	Metrics []string `type:"list"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// Sets the start and end dates for retrieving Amazon Web Services costs. The
	// range must be within the last 14 days (the start date cannot be earlier than
	// 14 days ago). The start date is inclusive, but the end date is exclusive.
	// For example, if start is 2017-01-01 and end is 2017-05-01, then the cost
	// and usage data is retrieved from 2017-01-01 up to and including 2017-04-30
	// but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCostAndUsageWithResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCostAndUsageWithResourcesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCostAndUsageWithResourcesInput"}

	if s.TimePeriod == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetCostAndUsageWithResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The groups that are specified by the Filter or GroupBy parameters in the
	// request.
	GroupDefinitions []GroupDefinition `type:"list"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The time period that is covered by the results in the response.
	ResultsByTime []ResultByTime `type:"list"`
}

// String returns the string representation
func (s GetCostAndUsageWithResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetCostAndUsageWithResources = "GetCostAndUsageWithResources"

// GetCostAndUsageWithResourcesRequest returns a request value for making API operation for
// AWS Cost Explorer Service.
//
// Retrieves cost and usage metrics with resources for your account. You can
// specify which cost and usage-related metric, such as BlendedCosts or UsageQuantity,
// that you want the request to return. You can also filter and group your data
// by various dimensions, such as SERVICE or AZ, in a specific time range. For
// a complete list of valid dimensions, see the GetDimensionValues (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html)
// operation. Master accounts in an organization in AWS Organizations have access
// to all member accounts. This API is currently available for the Amazon Elastic
// Compute Cloud – Compute service only.
//
// This is an opt-in only feature. You can enable this feature from the Cost
// Explorer Settings page. For information on how to access the Settings page,
// see Controlling Access for Cost Explorer (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-access.html)
// in the AWS Billing and Cost Management User Guide.
//
//    // Example sending a request using GetCostAndUsageWithResourcesRequest.
//    req := client.GetCostAndUsageWithResourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsageWithResources
func (c *Client) GetCostAndUsageWithResourcesRequest(input *GetCostAndUsageWithResourcesInput) GetCostAndUsageWithResourcesRequest {
	op := &aws.Operation{
		Name:       opGetCostAndUsageWithResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCostAndUsageWithResourcesInput{}
	}

	req := c.newRequest(op, input, &GetCostAndUsageWithResourcesOutput{})

	return GetCostAndUsageWithResourcesRequest{Request: req, Input: input, Copy: c.GetCostAndUsageWithResourcesRequest}
}

// GetCostAndUsageWithResourcesRequest is the request type for the
// GetCostAndUsageWithResources API operation.
type GetCostAndUsageWithResourcesRequest struct {
	*aws.Request
	Input *GetCostAndUsageWithResourcesInput
	Copy  func(*GetCostAndUsageWithResourcesInput) GetCostAndUsageWithResourcesRequest
}

// Send marshals and sends the GetCostAndUsageWithResources API request.
func (r GetCostAndUsageWithResourcesRequest) Send(ctx context.Context) (*GetCostAndUsageWithResourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCostAndUsageWithResourcesResponse{
		GetCostAndUsageWithResourcesOutput: r.Request.Data.(*GetCostAndUsageWithResourcesOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCostAndUsageWithResourcesResponse is the response type for the
// GetCostAndUsageWithResources API operation.
type GetCostAndUsageWithResourcesResponse struct {
	*GetCostAndUsageWithResourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCostAndUsageWithResources request.
func (r *GetCostAndUsageWithResourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
