// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteCertificateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted certificate.
	//
	// CertificateArn is a required field
	CertificateArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteCertificateInput"}

	if s.CertificateArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The Secure Sockets Layer (SSL) certificate.
	Certificate *Certificate `type:"structure"`
}

// String returns the string representation
func (s DeleteCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteCertificate = "DeleteCertificate"

// DeleteCertificateRequest returns a request value for making API operation for
// AWS Database Migration Service.
//
// Deletes the specified certificate.
//
//    // Example sending a request using DeleteCertificateRequest.
//    req := client.DeleteCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate
func (c *Client) DeleteCertificateRequest(input *DeleteCertificateInput) DeleteCertificateRequest {
	op := &aws.Operation{
		Name:       opDeleteCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCertificateInput{}
	}

	req := c.newRequest(op, input, &DeleteCertificateOutput{})

	return DeleteCertificateRequest{Request: req, Input: input, Copy: c.DeleteCertificateRequest}
}

// DeleteCertificateRequest is the request type for the
// DeleteCertificate API operation.
type DeleteCertificateRequest struct {
	*aws.Request
	Input *DeleteCertificateInput
	Copy  func(*DeleteCertificateInput) DeleteCertificateRequest
}

// Send marshals and sends the DeleteCertificate API request.
func (r DeleteCertificateRequest) Send(ctx context.Context) (*DeleteCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteCertificateResponse{
		DeleteCertificateOutput: r.Request.Data.(*DeleteCertificateOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteCertificateResponse is the response type for the
// DeleteCertificate API operation.
type DeleteCertificateResponse struct {
	*DeleteCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteCertificate request.
func (r *DeleteCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
