// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeReplicationTasksInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the describe action.
	//
	// Valid filter names: replication-task-arn | replication-task-id | migration-type
	// | endpoint-arn | replication-instance-arn
	Filters []Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// An option to set to avoid returning information about settings. Use this
	// to reduce overhead when setting information is too large. To use this option,
	// choose true; otherwise, choose false (the default).
	WithoutSettings *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeReplicationTasksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationTasksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeReplicationTasksInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeReplicationTasksOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A description of the replication tasks.
	ReplicationTasks []ReplicationTask `type:"list"`
}

// String returns the string representation
func (s DescribeReplicationTasksOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeReplicationTasks = "DescribeReplicationTasks"

// DescribeReplicationTasksRequest returns a request value for making API operation for
// AWS Database Migration Service.
//
// Returns information about replication tasks for your account in the current
// region.
//
//    // Example sending a request using DescribeReplicationTasksRequest.
//    req := client.DescribeReplicationTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks
func (c *Client) DescribeReplicationTasksRequest(input *DescribeReplicationTasksInput) DescribeReplicationTasksRequest {
	op := &aws.Operation{
		Name:       opDescribeReplicationTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationTasksInput{}
	}

	req := c.newRequest(op, input, &DescribeReplicationTasksOutput{})

	return DescribeReplicationTasksRequest{Request: req, Input: input, Copy: c.DescribeReplicationTasksRequest}
}

// DescribeReplicationTasksRequest is the request type for the
// DescribeReplicationTasks API operation.
type DescribeReplicationTasksRequest struct {
	*aws.Request
	Input *DescribeReplicationTasksInput
	Copy  func(*DescribeReplicationTasksInput) DescribeReplicationTasksRequest
}

// Send marshals and sends the DescribeReplicationTasks API request.
func (r DescribeReplicationTasksRequest) Send(ctx context.Context) (*DescribeReplicationTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeReplicationTasksResponse{
		DescribeReplicationTasksOutput: r.Request.Data.(*DescribeReplicationTasksOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeReplicationTasksRequestPaginator returns a paginator for DescribeReplicationTasks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeReplicationTasksRequest(input)
//   p := databasemigrationservice.NewDescribeReplicationTasksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeReplicationTasksPaginator(req DescribeReplicationTasksRequest) DescribeReplicationTasksPaginator {
	return DescribeReplicationTasksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeReplicationTasksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeReplicationTasksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeReplicationTasksPaginator struct {
	aws.Pager
}

func (p *DescribeReplicationTasksPaginator) CurrentPage() *DescribeReplicationTasksOutput {
	return p.Pager.CurrentPage().(*DescribeReplicationTasksOutput)
}

// DescribeReplicationTasksResponse is the response type for the
// DescribeReplicationTasks API operation.
type DescribeReplicationTasksResponse struct {
	*DescribeReplicationTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeReplicationTasks request.
func (r *DescribeReplicationTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
