// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyReplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) to be allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that major version upgrades are allowed. Changing this parameter
	// does not result in an outage, and the change is asynchronously applied as
	// soon as possible.
	//
	// This parameter must be set to true when specifying a value for the EngineVersion
	// parameter that is a different major version than the replication instance's
	// current version.
	AllowMajorVersionUpgrade *bool `type:"boolean"`

	// Indicates whether the changes should be applied immediately or during the
	// next maintenance window.
	ApplyImmediately *bool `type:"boolean"`

	// A value that indicates that minor version upgrades are applied automatically
	// to the replication instance during the maintenance window. Changing this
	// parameter doesn't result in an outage, except in the case dsecribed following.
	// The change is asynchronously applied as soon as possible.
	//
	// An outage does result if these factors apply:
	//
	//    * This parameter is set to true during the maintenance window.
	//
	//    * A newer minor version is available.
	//
	//    * AWS DMS has enabled automatic patching for the given engine version.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The engine version number of the replication instance.
	EngineVersion *string `type:"string"`

	// Specifies whether the replication instance is a Multi-AZ deployment. You
	// can't set the AvailabilityZone parameter if the Multi-AZ parameter is set
	// to true.
	MultiAZ *bool `type:"boolean"`

	// The weekly time range (in UTC) during which system maintenance can occur,
	// which might result in an outage. Changing this parameter does not result
	// in an outage, except in the following situation, and the change is asynchronously
	// applied as soon as possible. If moving this window to the current time, there
	// must be at least 30 minutes between the current time and end of the window
	// to ensure pending changes are applied.
	//
	// Default: Uses existing setting
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Must be at least 30 minutes
	PreferredMaintenanceWindow *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`

	// The compute and memory capacity of the replication instance as defined for
	// the specified replication instance class. For example to specify the instance
	// class dms.c4.large, set this parameter to "dms.c4.large".
	//
	// For more information on the settings and capacities for the available replication
	// instance classes, see Selecting the right AWS DMS replication instance for
	// your migration (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth).
	ReplicationInstanceClass *string `type:"string"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	ReplicationInstanceIdentifier *string `type:"string"`

	// Specifies the VPC security group to be used with the replication instance.
	// The VPC security group must work with the VPC containing the replication
	// instance.
	VpcSecurityGroupIds []string `type:"list"`
}

// String returns the string representation
func (s ModifyReplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyReplicationInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyReplicationInstanceInput"}

	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyReplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The modified replication instance.
	ReplicationInstance *ReplicationInstance `type:"structure"`
}

// String returns the string representation
func (s ModifyReplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyReplicationInstance = "ModifyReplicationInstance"

// ModifyReplicationInstanceRequest returns a request value for making API operation for
// AWS Database Migration Service.
//
// Modifies the replication instance to apply new settings. You can change one
// or more parameters by specifying these parameters and the new values in the
// request.
//
// Some settings are applied during the maintenance window.
//
//    // Example sending a request using ModifyReplicationInstanceRequest.
//    req := client.ModifyReplicationInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstance
func (c *Client) ModifyReplicationInstanceRequest(input *ModifyReplicationInstanceInput) ModifyReplicationInstanceRequest {
	op := &aws.Operation{
		Name:       opModifyReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationInstanceInput{}
	}

	req := c.newRequest(op, input, &ModifyReplicationInstanceOutput{})

	return ModifyReplicationInstanceRequest{Request: req, Input: input, Copy: c.ModifyReplicationInstanceRequest}
}

// ModifyReplicationInstanceRequest is the request type for the
// ModifyReplicationInstance API operation.
type ModifyReplicationInstanceRequest struct {
	*aws.Request
	Input *ModifyReplicationInstanceInput
	Copy  func(*ModifyReplicationInstanceInput) ModifyReplicationInstanceRequest
}

// Send marshals and sends the ModifyReplicationInstance API request.
func (r ModifyReplicationInstanceRequest) Send(ctx context.Context) (*ModifyReplicationInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyReplicationInstanceResponse{
		ModifyReplicationInstanceOutput: r.Request.Data.(*ModifyReplicationInstanceOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyReplicationInstanceResponse is the response type for the
// ModifyReplicationInstance API operation.
type ModifyReplicationInstanceResponse struct {
	*ModifyReplicationInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyReplicationInstance request.
func (r *ModifyReplicationInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
