// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dataexchange

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListDataSetRevisionsInput struct {
	_ struct{} `type:"structure"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDataSetRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSetRevisionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDataSetRevisionsInput"}

	if s.DataSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListDataSetRevisionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListDataSetRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `type:"string"`

	Revisions []RevisionEntry `type:"list"`
}

// String returns the string representation
func (s ListDataSetRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListDataSetRevisionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Revisions != nil {
		v := s.Revisions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Revisions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListDataSetRevisions = "ListDataSetRevisions"

// ListDataSetRevisionsRequest returns a request value for making API operation for
// AWS Data Exchange.
//
// This operation lists a data set's revisions sorted by CreatedAt in descending
// order.
//
//    // Example sending a request using ListDataSetRevisionsRequest.
//    req := client.ListDataSetRevisionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListDataSetRevisions
func (c *Client) ListDataSetRevisionsRequest(input *ListDataSetRevisionsInput) ListDataSetRevisionsRequest {
	op := &aws.Operation{
		Name:       opListDataSetRevisions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSetRevisionsInput{}
	}

	req := c.newRequest(op, input, &ListDataSetRevisionsOutput{})

	return ListDataSetRevisionsRequest{Request: req, Input: input, Copy: c.ListDataSetRevisionsRequest}
}

// ListDataSetRevisionsRequest is the request type for the
// ListDataSetRevisions API operation.
type ListDataSetRevisionsRequest struct {
	*aws.Request
	Input *ListDataSetRevisionsInput
	Copy  func(*ListDataSetRevisionsInput) ListDataSetRevisionsRequest
}

// Send marshals and sends the ListDataSetRevisions API request.
func (r ListDataSetRevisionsRequest) Send(ctx context.Context) (*ListDataSetRevisionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDataSetRevisionsResponse{
		ListDataSetRevisionsOutput: r.Request.Data.(*ListDataSetRevisionsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListDataSetRevisionsRequestPaginator returns a paginator for ListDataSetRevisions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListDataSetRevisionsRequest(input)
//   p := dataexchange.NewListDataSetRevisionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListDataSetRevisionsPaginator(req ListDataSetRevisionsRequest) ListDataSetRevisionsPaginator {
	return ListDataSetRevisionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListDataSetRevisionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListDataSetRevisionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListDataSetRevisionsPaginator struct {
	aws.Pager
}

func (p *ListDataSetRevisionsPaginator) CurrentPage() *ListDataSetRevisionsOutput {
	return p.Pager.CurrentPage().(*ListDataSetRevisionsOutput)
}

// ListDataSetRevisionsResponse is the response type for the
// ListDataSetRevisions API operation.
type ListDataSetRevisionsResponse struct {
	*ListDataSetRevisionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDataSetRevisions request.
func (r *ListDataSetRevisionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
