// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dataexchange

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListDataSetsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	Origin *string `location:"querystring" locationName:"origin" type:"string"`
}

// String returns the string representation
func (s ListDataSetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDataSetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListDataSetsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Origin != nil {
		v := *s.Origin

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "origin", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListDataSetsOutput struct {
	_ struct{} `type:"structure"`

	DataSets []DataSetEntry `type:"list"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDataSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListDataSetsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataSets != nil {
		v := s.DataSets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DataSets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListDataSets = "ListDataSets"

// ListDataSetsRequest returns a request value for making API operation for
// AWS Data Exchange.
//
// This operation lists your data sets. When listing by origin OWNED, results
// are sorted by CreatedAt in descending order. When listing by origin ENTITLED,
// there is no order and the maxResults parameter is ignored.
//
//    // Example sending a request using ListDataSetsRequest.
//    req := client.ListDataSetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListDataSets
func (c *Client) ListDataSetsRequest(input *ListDataSetsInput) ListDataSetsRequest {
	op := &aws.Operation{
		Name:       opListDataSets,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/data-sets",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSetsInput{}
	}

	req := c.newRequest(op, input, &ListDataSetsOutput{})

	return ListDataSetsRequest{Request: req, Input: input, Copy: c.ListDataSetsRequest}
}

// ListDataSetsRequest is the request type for the
// ListDataSets API operation.
type ListDataSetsRequest struct {
	*aws.Request
	Input *ListDataSetsInput
	Copy  func(*ListDataSetsInput) ListDataSetsRequest
}

// Send marshals and sends the ListDataSets API request.
func (r ListDataSetsRequest) Send(ctx context.Context) (*ListDataSetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDataSetsResponse{
		ListDataSetsOutput: r.Request.Data.(*ListDataSetsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListDataSetsRequestPaginator returns a paginator for ListDataSets.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListDataSetsRequest(input)
//   p := dataexchange.NewListDataSetsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListDataSetsPaginator(req ListDataSetsRequest) ListDataSetsPaginator {
	return ListDataSetsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListDataSetsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListDataSetsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListDataSetsPaginator struct {
	aws.Pager
}

func (p *ListDataSetsPaginator) CurrentPage() *ListDataSetsOutput {
	return p.Pager.CurrentPage().(*ListDataSetsOutput)
}

// ListDataSetsResponse is the response type for the
// ListDataSets API operation.
type ListDataSetsResponse struct {
	*ListDataSetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDataSets request.
func (r *ListDataSetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
