// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datasync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// DeleteTask
type DeleteTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task to delete.
	//
	// TaskArn is a required field
	TaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTaskInput"}

	if s.TaskArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTaskOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteTask = "DeleteTask"

// DeleteTaskRequest returns a request value for making API operation for
// AWS DataSync.
//
// Deletes a task.
//
//    // Example sending a request using DeleteTaskRequest.
//    req := client.DeleteTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteTask
func (c *Client) DeleteTaskRequest(input *DeleteTaskInput) DeleteTaskRequest {
	op := &aws.Operation{
		Name:       opDeleteTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTaskInput{}
	}

	req := c.newRequest(op, input, &DeleteTaskOutput{})

	return DeleteTaskRequest{Request: req, Input: input, Copy: c.DeleteTaskRequest}
}

// DeleteTaskRequest is the request type for the
// DeleteTask API operation.
type DeleteTaskRequest struct {
	*aws.Request
	Input *DeleteTaskInput
	Copy  func(*DeleteTaskInput) DeleteTaskRequest
}

// Send marshals and sends the DeleteTask API request.
func (r DeleteTaskRequest) Send(ctx context.Context) (*DeleteTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTaskResponse{
		DeleteTaskOutput: r.Request.Data.(*DeleteTaskOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTaskResponse is the response type for the
// DeleteTask API operation.
type DeleteTaskResponse struct {
	*DeleteTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTask request.
func (r *DeleteTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
