// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package detective

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListGraphsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of graphs to return at a time. The total must be less
	// than the overall limit on the number of results to return, which is currently
	// 200.
	MaxResults *int64 `min:"1" type:"integer"`

	// For requests to get the next page of results, the pagination token that was
	// returned with the previous set of results. The initial request does not include
	// a pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGraphsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGraphsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListGraphsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListGraphsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListGraphsOutput struct {
	_ struct{} `type:"structure"`

	// A list of behavior graphs that the account is a master for.
	GraphList []Graph `type:"list"`

	// If there are more behavior graphs remaining in the results, then this is
	// the pagination token to use to request the next page of behavior graphs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGraphsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListGraphsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GraphList != nil {
		v := s.GraphList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "GraphList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListGraphs = "ListGraphs"

// ListGraphsRequest returns a request value for making API operation for
// Amazon Detective.
//
// Returns the list of behavior graphs that the calling account is a master
// of. This operation can only be called by a master account.
//
// Because an account can currently only be the master of one behavior graph
// within a Region, the results always contain a single graph.
//
//    // Example sending a request using ListGraphsRequest.
//    req := client.ListGraphsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListGraphs
func (c *Client) ListGraphsRequest(input *ListGraphsInput) ListGraphsRequest {
	op := &aws.Operation{
		Name:       opListGraphs,
		HTTPMethod: "POST",
		HTTPPath:   "/graphs/list",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGraphsInput{}
	}

	req := c.newRequest(op, input, &ListGraphsOutput{})

	return ListGraphsRequest{Request: req, Input: input, Copy: c.ListGraphsRequest}
}

// ListGraphsRequest is the request type for the
// ListGraphs API operation.
type ListGraphsRequest struct {
	*aws.Request
	Input *ListGraphsInput
	Copy  func(*ListGraphsInput) ListGraphsRequest
}

// Send marshals and sends the ListGraphs API request.
func (r ListGraphsRequest) Send(ctx context.Context) (*ListGraphsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListGraphsResponse{
		ListGraphsOutput: r.Request.Data.(*ListGraphsOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListGraphsRequestPaginator returns a paginator for ListGraphs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListGraphsRequest(input)
//   p := detective.NewListGraphsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListGraphsPaginator(req ListGraphsRequest) ListGraphsPaginator {
	return ListGraphsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListGraphsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListGraphsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListGraphsPaginator struct {
	aws.Pager
}

func (p *ListGraphsPaginator) CurrentPage() *ListGraphsOutput {
	return p.Pager.CurrentPage().(*ListGraphsOutput)
}

// ListGraphsResponse is the response type for the
// ListGraphs API operation.
type ListGraphsResponse struct {
	*ListGraphsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListGraphs request.
func (r *ListGraphsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
