// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateTestGridUrlInput struct {
	_ struct{} `type:"structure"`

	// Lifetime, in seconds, of the URL.
	//
	// ExpiresInSeconds is a required field
	ExpiresInSeconds *int64 `locationName:"expiresInSeconds" min:"60" type:"integer" required:"true"`

	// ARN (from CreateTestGridProject or ListTestGridProjects) to associate with
	// the short-term URL.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTestGridUrlInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTestGridUrlInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateTestGridUrlInput"}

	if s.ExpiresInSeconds == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExpiresInSeconds"))
	}
	if s.ExpiresInSeconds != nil && *s.ExpiresInSeconds < 60 {
		invalidParams.Add(aws.NewErrParamMinValue("ExpiresInSeconds", 60))
	}

	if s.ProjectArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateTestGridUrlOutput struct {
	_ struct{} `type:"structure"`

	// The number of seconds the URL from CreateTestGridUrlResult$url stays active.
	Expires *time.Time `locationName:"expires" type:"timestamp"`

	// A signed URL, expiring in CreateTestGridUrlRequest$expiresInSeconds seconds,
	// to be passed to a RemoteWebDriver.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s CreateTestGridUrlOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateTestGridUrl = "CreateTestGridUrl"

// CreateTestGridUrlRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Creates a signed, short-term URL that can be passed to a Selenium RemoteWebDriver
// constructor.
//
//    // Example sending a request using CreateTestGridUrlRequest.
//    req := client.CreateTestGridUrlRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateTestGridUrl
func (c *Client) CreateTestGridUrlRequest(input *CreateTestGridUrlInput) CreateTestGridUrlRequest {
	op := &aws.Operation{
		Name:       opCreateTestGridUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTestGridUrlInput{}
	}

	req := c.newRequest(op, input, &CreateTestGridUrlOutput{})

	return CreateTestGridUrlRequest{Request: req, Input: input, Copy: c.CreateTestGridUrlRequest}
}

// CreateTestGridUrlRequest is the request type for the
// CreateTestGridUrl API operation.
type CreateTestGridUrlRequest struct {
	*aws.Request
	Input *CreateTestGridUrlInput
	Copy  func(*CreateTestGridUrlInput) CreateTestGridUrlRequest
}

// Send marshals and sends the CreateTestGridUrl API request.
func (r CreateTestGridUrlRequest) Send(ctx context.Context) (*CreateTestGridUrlResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateTestGridUrlResponse{
		CreateTestGridUrlOutput: r.Request.Data.(*CreateTestGridUrlOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateTestGridUrlResponse is the response type for the
// CreateTestGridUrl API operation.
type CreateTestGridUrlResponse struct {
	*CreateTestGridUrlOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTestGridUrl request.
func (r *CreateTestGridUrlResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
