// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to the delete run operation.
type DeleteRunInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the run to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRunInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRunInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRunInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the result of a delete run request.
type DeleteRunOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRunOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteRun = "DeleteRun"

// DeleteRunRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Deletes the run, given the run ARN.
//
// Deleting this resource does not stop an in-progress run.
//
//    // Example sending a request using DeleteRunRequest.
//    req := client.DeleteRunRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRun
func (c *Client) DeleteRunRequest(input *DeleteRunInput) DeleteRunRequest {
	op := &aws.Operation{
		Name:       opDeleteRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRunInput{}
	}

	req := c.newRequest(op, input, &DeleteRunOutput{})

	return DeleteRunRequest{Request: req, Input: input, Copy: c.DeleteRunRequest}
}

// DeleteRunRequest is the request type for the
// DeleteRun API operation.
type DeleteRunRequest struct {
	*aws.Request
	Input *DeleteRunInput
	Copy  func(*DeleteRunInput) DeleteRunRequest
}

// Send marshals and sends the DeleteRun API request.
func (r DeleteRunRequest) Send(ctx context.Context) (*DeleteRunResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRunResponse{
		DeleteRunOutput: r.Request.Data.(*DeleteRunOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRunResponse is the response type for the
// DeleteRun API operation.
type DeleteRunResponse struct {
	*DeleteRunOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRun request.
func (r *DeleteRunResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
