// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to the get test operation.
type GetTestInput struct {
	_ struct{} `type:"structure"`

	// The test's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTestInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTestInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTestInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the result of a get test request.
type GetTestOutput struct {
	_ struct{} `type:"structure"`

	// A test condition that is evaluated.
	Test *Test `locationName:"test" type:"structure"`
}

// String returns the string representation
func (s GetTestOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetTest = "GetTest"

// GetTestRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Gets information about a test.
//
//    // Example sending a request using GetTestRequest.
//    req := client.GetTestRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTest
func (c *Client) GetTestRequest(input *GetTestInput) GetTestRequest {
	op := &aws.Operation{
		Name:       opGetTest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTestInput{}
	}

	req := c.newRequest(op, input, &GetTestOutput{})

	return GetTestRequest{Request: req, Input: input, Copy: c.GetTestRequest}
}

// GetTestRequest is the request type for the
// GetTest API operation.
type GetTestRequest struct {
	*aws.Request
	Input *GetTestInput
	Copy  func(*GetTestInput) GetTestRequest
}

// Send marshals and sends the GetTest API request.
func (r GetTestRequest) Send(ctx context.Context) (*GetTestResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTestResponse{
		GetTestOutput: r.Request.Data.(*GetTestOutput),
		response:      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetTestResponse is the response type for the
// GetTest API operation.
type GetTestResponse struct {
	*GetTestOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTest request.
func (r *GetTestResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
