// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListInstanceProfilesInput struct {
	_ struct{} `type:"structure"`

	// An integer that specifies the maximum number of items you want to return
	// in the API response.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListInstanceProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstanceProfilesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListInstanceProfilesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListInstanceProfilesOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about your instance profiles.
	InstanceProfiles []InstanceProfile `locationName:"instanceProfiles" type:"list"`

	// An identifier that can be used in the next call to this operation to return
	// the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListInstanceProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListInstanceProfiles = "ListInstanceProfiles"

// ListInstanceProfilesRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Returns information about all the instance profiles in an AWS account.
//
//    // Example sending a request using ListInstanceProfilesRequest.
//    req := client.ListInstanceProfilesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListInstanceProfiles
func (c *Client) ListInstanceProfilesRequest(input *ListInstanceProfilesInput) ListInstanceProfilesRequest {
	op := &aws.Operation{
		Name:       opListInstanceProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListInstanceProfilesInput{}
	}

	req := c.newRequest(op, input, &ListInstanceProfilesOutput{})

	return ListInstanceProfilesRequest{Request: req, Input: input, Copy: c.ListInstanceProfilesRequest}
}

// ListInstanceProfilesRequest is the request type for the
// ListInstanceProfiles API operation.
type ListInstanceProfilesRequest struct {
	*aws.Request
	Input *ListInstanceProfilesInput
	Copy  func(*ListInstanceProfilesInput) ListInstanceProfilesRequest
}

// Send marshals and sends the ListInstanceProfiles API request.
func (r ListInstanceProfilesRequest) Send(ctx context.Context) (*ListInstanceProfilesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListInstanceProfilesResponse{
		ListInstanceProfilesOutput: r.Request.Data.(*ListInstanceProfilesOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListInstanceProfilesResponse is the response type for the
// ListInstanceProfiles API operation.
type ListInstanceProfilesResponse struct {
	*ListInstanceProfilesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListInstanceProfiles request.
func (r *ListInstanceProfilesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
