// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTestGridSessionsInput struct {
	_ struct{} `type:"structure"`

	// Return only sessions created after this time.
	CreationTimeAfter *time.Time `locationName:"creationTimeAfter" type:"timestamp"`

	// Return only sessions created before this time.
	CreationTimeBefore *time.Time `locationName:"creationTimeBefore" type:"timestamp"`

	// Return only sessions that ended after this time.
	EndTimeAfter *time.Time `locationName:"endTimeAfter" type:"timestamp"`

	// Return only sessions that ended before this time.
	EndTimeBefore *time.Time `locationName:"endTimeBefore" type:"timestamp"`

	// Return only this many results at a time.
	MaxResult *int64 `locationName:"maxResult" min:"1" type:"integer"`

	// Pagination token.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// ARN of a TestGridProject.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`

	// Return only sessions in this state.
	Status TestGridSessionStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListTestGridSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestGridSessionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTestGridSessionsInput"}
	if s.MaxResult != nil && *s.MaxResult < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResult", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 4))
	}

	if s.ProjectArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTestGridSessionsOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The sessions that match the criteria in a ListTestGridSessionsRequest.
	TestGridSessions []TestGridSession `locationName:"testGridSessions" type:"list"`
}

// String returns the string representation
func (s ListTestGridSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTestGridSessions = "ListTestGridSessions"

// ListTestGridSessionsRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Retrieves a list of sessions for a TestGridProject.
//
//    // Example sending a request using ListTestGridSessionsRequest.
//    req := client.ListTestGridSessionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessions
func (c *Client) ListTestGridSessionsRequest(input *ListTestGridSessionsInput) ListTestGridSessionsRequest {
	op := &aws.Operation{
		Name:       opListTestGridSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResult",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestGridSessionsInput{}
	}

	req := c.newRequest(op, input, &ListTestGridSessionsOutput{})

	return ListTestGridSessionsRequest{Request: req, Input: input, Copy: c.ListTestGridSessionsRequest}
}

// ListTestGridSessionsRequest is the request type for the
// ListTestGridSessions API operation.
type ListTestGridSessionsRequest struct {
	*aws.Request
	Input *ListTestGridSessionsInput
	Copy  func(*ListTestGridSessionsInput) ListTestGridSessionsRequest
}

// Send marshals and sends the ListTestGridSessions API request.
func (r ListTestGridSessionsRequest) Send(ctx context.Context) (*ListTestGridSessionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTestGridSessionsResponse{
		ListTestGridSessionsOutput: r.Request.Data.(*ListTestGridSessionsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTestGridSessionsRequestPaginator returns a paginator for ListTestGridSessions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTestGridSessionsRequest(input)
//   p := devicefarm.NewListTestGridSessionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTestGridSessionsPaginator(req ListTestGridSessionsRequest) ListTestGridSessionsPaginator {
	return ListTestGridSessionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTestGridSessionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTestGridSessionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTestGridSessionsPaginator struct {
	aws.Pager
}

func (p *ListTestGridSessionsPaginator) CurrentPage() *ListTestGridSessionsOutput {
	return p.Pager.CurrentPage().(*ListTestGridSessionsOutput)
}

// ListTestGridSessionsResponse is the response type for the
// ListTestGridSessions API operation.
type ListTestGridSessionsResponse struct {
	*ListTestGridSessionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTestGridSessions request.
func (r *ListTestGridSessionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
