// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateDeviceInstanceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the device instance.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An array of strings that you want to associate with the device instance.
	Labels []string `locationName:"labels" type:"list"`

	// The ARN of the profile that you want to associate with the device instance.
	ProfileArn *string `locationName:"profileArn" min:"32" type:"string"`
}

// String returns the string representation
func (s UpdateDeviceInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeviceInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDeviceInstanceInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}
	if s.ProfileArn != nil && len(*s.ProfileArn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfileArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateDeviceInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about your device instance.
	DeviceInstance *DeviceInstance `locationName:"deviceInstance" type:"structure"`
}

// String returns the string representation
func (s UpdateDeviceInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDeviceInstance = "UpdateDeviceInstance"

// UpdateDeviceInstanceRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Updates information about a private device instance.
//
//    // Example sending a request using UpdateDeviceInstanceRequest.
//    req := client.UpdateDeviceInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDeviceInstance
func (c *Client) UpdateDeviceInstanceRequest(input *UpdateDeviceInstanceInput) UpdateDeviceInstanceRequest {
	op := &aws.Operation{
		Name:       opUpdateDeviceInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeviceInstanceInput{}
	}

	req := c.newRequest(op, input, &UpdateDeviceInstanceOutput{})

	return UpdateDeviceInstanceRequest{Request: req, Input: input, Copy: c.UpdateDeviceInstanceRequest}
}

// UpdateDeviceInstanceRequest is the request type for the
// UpdateDeviceInstance API operation.
type UpdateDeviceInstanceRequest struct {
	*aws.Request
	Input *UpdateDeviceInstanceInput
	Copy  func(*UpdateDeviceInstanceInput) UpdateDeviceInstanceRequest
}

// Send marshals and sends the UpdateDeviceInstance API request.
func (r UpdateDeviceInstanceRequest) Send(ctx context.Context) (*UpdateDeviceInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDeviceInstanceResponse{
		UpdateDeviceInstanceOutput: r.Request.Data.(*UpdateDeviceInstanceOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDeviceInstanceResponse is the response type for the
// UpdateDeviceInstance API operation.
type UpdateDeviceInstanceResponse struct {
	*UpdateDeviceInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDeviceInstance request.
func (r *UpdateDeviceInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
