// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateTestGridProjectInput struct {
	_ struct{} `type:"structure"`

	// Human-readable description for the project.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Human-readable name for the project.
	Name *string `locationName:"name" min:"1" type:"string"`

	// ARN of the project to update.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTestGridProjectInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTestGridProjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateTestGridProjectInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.ProjectArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateTestGridProjectOutput struct {
	_ struct{} `type:"structure"`

	// The project, including updated information.
	TestGridProject *TestGridProject `locationName:"testGridProject" type:"structure"`
}

// String returns the string representation
func (s UpdateTestGridProjectOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateTestGridProject = "UpdateTestGridProject"

// UpdateTestGridProjectRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Change details of a project.
//
//    // Example sending a request using UpdateTestGridProjectRequest.
//    req := client.UpdateTestGridProjectRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateTestGridProject
func (c *Client) UpdateTestGridProjectRequest(input *UpdateTestGridProjectInput) UpdateTestGridProjectRequest {
	op := &aws.Operation{
		Name:       opUpdateTestGridProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTestGridProjectInput{}
	}

	req := c.newRequest(op, input, &UpdateTestGridProjectOutput{})

	return UpdateTestGridProjectRequest{Request: req, Input: input, Copy: c.UpdateTestGridProjectRequest}
}

// UpdateTestGridProjectRequest is the request type for the
// UpdateTestGridProject API operation.
type UpdateTestGridProjectRequest struct {
	*aws.Request
	Input *UpdateTestGridProjectInput
	Copy  func(*UpdateTestGridProjectInput) UpdateTestGridProjectRequest
}

// Send marshals and sends the UpdateTestGridProject API request.
func (r UpdateTestGridProjectRequest) Send(ctx context.Context) (*UpdateTestGridProjectResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateTestGridProjectResponse{
		UpdateTestGridProjectOutput: r.Request.Data.(*UpdateTestGridProjectOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateTestGridProjectResponse is the response type for the
// UpdateTestGridProject API operation.
type UpdateTestGridProjectResponse struct {
	*UpdateTestGridProjectOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateTestGridProject request.
func (r *UpdateTestGridProjectResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
