// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDirectConnectGatewayAssociationProposalsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the associated gateway.
	AssociatedGatewayId *string `locationName:"associatedGatewayId" type:"string"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	//
	// If MaxResults is given a value larger than 100, only 100 results are returned.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the proposal.
	ProposalId *string `locationName:"proposalId" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewayAssociationProposalsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeDirectConnectGatewayAssociationProposalsOutput struct {
	_ struct{} `type:"structure"`

	// Describes the Direct Connect gateway association proposals.
	DirectConnectGatewayAssociationProposals []DirectConnectGatewayAssociationProposal `locationName:"directConnectGatewayAssociationProposals" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewayAssociationProposalsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDirectConnectGatewayAssociationProposals = "DescribeDirectConnectGatewayAssociationProposals"

// DescribeDirectConnectGatewayAssociationProposalsRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Describes one or more association proposals for connection between a virtual
// private gateway or transit gateway and a Direct Connect gateway.
//
//    // Example sending a request using DescribeDirectConnectGatewayAssociationProposalsRequest.
//    req := client.DescribeDirectConnectGatewayAssociationProposalsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociationProposals
func (c *Client) DescribeDirectConnectGatewayAssociationProposalsRequest(input *DescribeDirectConnectGatewayAssociationProposalsInput) DescribeDirectConnectGatewayAssociationProposalsRequest {
	op := &aws.Operation{
		Name:       opDescribeDirectConnectGatewayAssociationProposals,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectConnectGatewayAssociationProposalsInput{}
	}

	req := c.newRequest(op, input, &DescribeDirectConnectGatewayAssociationProposalsOutput{})

	return DescribeDirectConnectGatewayAssociationProposalsRequest{Request: req, Input: input, Copy: c.DescribeDirectConnectGatewayAssociationProposalsRequest}
}

// DescribeDirectConnectGatewayAssociationProposalsRequest is the request type for the
// DescribeDirectConnectGatewayAssociationProposals API operation.
type DescribeDirectConnectGatewayAssociationProposalsRequest struct {
	*aws.Request
	Input *DescribeDirectConnectGatewayAssociationProposalsInput
	Copy  func(*DescribeDirectConnectGatewayAssociationProposalsInput) DescribeDirectConnectGatewayAssociationProposalsRequest
}

// Send marshals and sends the DescribeDirectConnectGatewayAssociationProposals API request.
func (r DescribeDirectConnectGatewayAssociationProposalsRequest) Send(ctx context.Context) (*DescribeDirectConnectGatewayAssociationProposalsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDirectConnectGatewayAssociationProposalsResponse{
		DescribeDirectConnectGatewayAssociationProposalsOutput: r.Request.Data.(*DescribeDirectConnectGatewayAssociationProposalsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDirectConnectGatewayAssociationProposalsResponse is the response type for the
// DescribeDirectConnectGatewayAssociationProposals API operation.
type DescribeDirectConnectGatewayAssociationProposalsResponse struct {
	*DescribeDirectConnectGatewayAssociationProposalsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDirectConnectGatewayAssociationProposals request.
func (r *DescribeDirectConnectGatewayAssociationProposalsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
