// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeLoaInput struct {
	_ struct{} `type:"structure"`

	// The ID of a connection, LAG, or interconnect.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The standard media type for the LOA-CFA document. The only supported value
	// is application/pdf.
	LoaContentType LoaContentType `locationName:"loaContentType" type:"string" enum:"true"`

	// The name of the service provider who establishes connectivity on your behalf.
	// If you specify this parameter, the LOA-CFA lists the provider name alongside
	// your company name as the requester of the cross connect.
	ProviderName *string `locationName:"providerName" type:"string"`
}

// String returns the string representation
func (s DescribeLoaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLoaInput"}

	if s.ConnectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a Letter of Authorization - Connecting Facility Assignment
// (LOA-CFA) for a connection.
type DescribeLoaOutput struct {
	_ struct{} `type:"structure"`

	// The binary contents of the LOA-CFA document.
	//
	// LoaContent is automatically base64 encoded/decoded by the SDK.
	LoaContent []byte `locationName:"loaContent" type:"blob"`

	// The standard media type for the LOA-CFA document. The only supported value
	// is application/pdf.
	LoaContentType LoaContentType `locationName:"loaContentType" type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeLoaOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLoa = "DescribeLoa"

// DescribeLoaRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Gets the LOA-CFA for a connection, interconnect, or link aggregation group
// (LAG).
//
// The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is
// a document that is used when establishing your cross connect to AWS at the
// colocation facility. For more information, see Requesting Cross Connects
// at AWS Direct Connect Locations (https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html)
// in the AWS Direct Connect User Guide.
//
//    // Example sending a request using DescribeLoaRequest.
//    req := client.DescribeLoaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLoa
func (c *Client) DescribeLoaRequest(input *DescribeLoaInput) DescribeLoaRequest {
	op := &aws.Operation{
		Name:       opDescribeLoa,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoaInput{}
	}

	req := c.newRequest(op, input, &DescribeLoaOutput{})

	return DescribeLoaRequest{Request: req, Input: input, Copy: c.DescribeLoaRequest}
}

// DescribeLoaRequest is the request type for the
// DescribeLoa API operation.
type DescribeLoaRequest struct {
	*aws.Request
	Input *DescribeLoaInput
	Copy  func(*DescribeLoaInput) DescribeLoaRequest
}

// Send marshals and sends the DescribeLoa API request.
func (r DescribeLoaRequest) Send(ctx context.Context) (*DescribeLoaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLoaResponse{
		DescribeLoaOutput: r.Request.Data.(*DescribeLoaOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLoaResponse is the response type for the
// DescribeLoa API operation.
type DescribeLoaResponse struct {
	*DescribeLoaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLoa request.
func (r *DescribeLoaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
