// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeVirtualInterfacesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The ID of the virtual interface.
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`
}

// String returns the string representation
func (s DescribeVirtualInterfacesInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeVirtualInterfacesOutput struct {
	_ struct{} `type:"structure"`

	// The virtual interfaces
	VirtualInterfaces []VirtualInterface `locationName:"virtualInterfaces" type:"list"`
}

// String returns the string representation
func (s DescribeVirtualInterfacesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeVirtualInterfaces = "DescribeVirtualInterfaces"

// DescribeVirtualInterfacesRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Displays all virtual interfaces for an AWS account. Virtual interfaces deleted
// fewer than 15 minutes before you make the request are also returned. If you
// specify a connection ID, only the virtual interfaces associated with the
// connection are returned. If you specify a virtual interface ID, then only
// a single virtual interface is returned.
//
// A virtual interface (VLAN) transmits the traffic between the AWS Direct Connect
// location and the customer network.
//
//    // Example sending a request using DescribeVirtualInterfacesRequest.
//    req := client.DescribeVirtualInterfacesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualInterfaces
func (c *Client) DescribeVirtualInterfacesRequest(input *DescribeVirtualInterfacesInput) DescribeVirtualInterfacesRequest {
	op := &aws.Operation{
		Name:       opDescribeVirtualInterfaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVirtualInterfacesInput{}
	}

	req := c.newRequest(op, input, &DescribeVirtualInterfacesOutput{})

	return DescribeVirtualInterfacesRequest{Request: req, Input: input, Copy: c.DescribeVirtualInterfacesRequest}
}

// DescribeVirtualInterfacesRequest is the request type for the
// DescribeVirtualInterfaces API operation.
type DescribeVirtualInterfacesRequest struct {
	*aws.Request
	Input *DescribeVirtualInterfacesInput
	Copy  func(*DescribeVirtualInterfacesInput) DescribeVirtualInterfacesRequest
}

// Send marshals and sends the DescribeVirtualInterfaces API request.
func (r DescribeVirtualInterfacesRequest) Send(ctx context.Context) (*DescribeVirtualInterfacesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeVirtualInterfacesResponse{
		DescribeVirtualInterfacesOutput: r.Request.Data.(*DescribeVirtualInterfacesOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeVirtualInterfacesResponse is the response type for the
// DescribeVirtualInterfaces API operation.
type DescribeVirtualInterfacesResponse struct {
	*DescribeVirtualInterfacesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeVirtualInterfaces request.
func (r *DescribeVirtualInterfacesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
