// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopBgpFailoverTestInput struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual interface you no longer want to test.
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s StopBgpFailoverTestInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopBgpFailoverTestInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopBgpFailoverTestInput"}

	if s.VirtualInterfaceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopBgpFailoverTestOutput struct {
	_ struct{} `type:"structure"`

	// Information about the virtual interface failover test.
	VirtualInterfaceTest *VirtualInterfaceTestHistory `locationName:"virtualInterfaceTest" type:"structure"`
}

// String returns the string representation
func (s StopBgpFailoverTestOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopBgpFailoverTest = "StopBgpFailoverTest"

// StopBgpFailoverTestRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Stops the virtual interface failover test.
//
//    // Example sending a request using StopBgpFailoverTestRequest.
//    req := client.StopBgpFailoverTestRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/StopBgpFailoverTest
func (c *Client) StopBgpFailoverTestRequest(input *StopBgpFailoverTestInput) StopBgpFailoverTestRequest {
	op := &aws.Operation{
		Name:       opStopBgpFailoverTest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopBgpFailoverTestInput{}
	}

	req := c.newRequest(op, input, &StopBgpFailoverTestOutput{})

	return StopBgpFailoverTestRequest{Request: req, Input: input, Copy: c.StopBgpFailoverTestRequest}
}

// StopBgpFailoverTestRequest is the request type for the
// StopBgpFailoverTest API operation.
type StopBgpFailoverTestRequest struct {
	*aws.Request
	Input *StopBgpFailoverTestInput
	Copy  func(*StopBgpFailoverTestInput) StopBgpFailoverTestRequest
}

// Send marshals and sends the StopBgpFailoverTest API request.
func (r StopBgpFailoverTestRequest) Send(ctx context.Context) (*StopBgpFailoverTestResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopBgpFailoverTestResponse{
		StopBgpFailoverTestOutput: r.Request.Data.(*StopBgpFailoverTestOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopBgpFailoverTestResponse is the response type for the
// StopBgpFailoverTest API operation.
type StopBgpFailoverTestResponse struct {
	*StopBgpFailoverTestOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopBgpFailoverTest request.
func (r *StopBgpFailoverTestResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
