// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the inputs for the DeleteDirectory operation.
type DeleteDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory to delete.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDirectoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDirectoryInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the DeleteDirectory operation.
type DeleteDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The directory identifier.
	DirectoryId *string `type:"string"`
}

// String returns the string representation
func (s DeleteDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteDirectory = "DeleteDirectory"

// DeleteDirectoryRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Deletes an AWS Directory Service directory.
//
// Before you call DeleteDirectory, ensure that all of the required permissions
// have been explicitly granted through a policy. For details about what permissions
// are required to run the DeleteDirectory operation, see AWS Directory Service
// API Permissions: Actions, Resources, and Conditions Reference (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html).
//
//    // Example sending a request using DeleteDirectoryRequest.
//    req := client.DeleteDirectoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteDirectory
func (c *Client) DeleteDirectoryRequest(input *DeleteDirectoryInput) DeleteDirectoryRequest {
	op := &aws.Operation{
		Name:       opDeleteDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDirectoryInput{}
	}

	req := c.newRequest(op, input, &DeleteDirectoryOutput{})

	return DeleteDirectoryRequest{Request: req, Input: input, Copy: c.DeleteDirectoryRequest}
}

// DeleteDirectoryRequest is the request type for the
// DeleteDirectory API operation.
type DeleteDirectoryRequest struct {
	*aws.Request
	Input *DeleteDirectoryInput
	Copy  func(*DeleteDirectoryInput) DeleteDirectoryRequest
}

// Send marshals and sends the DeleteDirectory API request.
func (r DeleteDirectoryRequest) Send(ctx context.Context) (*DeleteDirectoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDirectoryResponse{
		DeleteDirectoryOutput: r.Request.Data.(*DeleteDirectoryOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDirectoryResponse is the response type for the
// DeleteDirectory API operation.
type DeleteDirectoryResponse struct {
	*DeleteDirectoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDirectory request.
func (r *DeleteDirectoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
