// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RegisterCertificateInput struct {
	_ struct{} `type:"structure"`

	// The certificate PEM string that needs to be registered.
	//
	// CertificateData is a required field
	CertificateData *string `min:"1" type:"string" required:"true"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterCertificateInput"}

	if s.CertificateData == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateData"))
	}
	if s.CertificateData != nil && len(*s.CertificateData) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateData", 1))
	}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RegisterCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the certificate.
	CertificateId *string `type:"string"`
}

// String returns the string representation
func (s RegisterCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterCertificate = "RegisterCertificate"

// RegisterCertificateRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Registers a certificate for secured LDAP connection.
//
//    // Example sending a request using RegisterCertificateRequest.
//    req := client.RegisterCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RegisterCertificate
func (c *Client) RegisterCertificateRequest(input *RegisterCertificateInput) RegisterCertificateRequest {
	op := &aws.Operation{
		Name:       opRegisterCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterCertificateInput{}
	}

	req := c.newRequest(op, input, &RegisterCertificateOutput{})

	return RegisterCertificateRequest{Request: req, Input: input, Copy: c.RegisterCertificateRequest}
}

// RegisterCertificateRequest is the request type for the
// RegisterCertificate API operation.
type RegisterCertificateRequest struct {
	*aws.Request
	Input *RegisterCertificateInput
	Copy  func(*RegisterCertificateInput) RegisterCertificateRequest
}

// Send marshals and sends the RegisterCertificate API request.
func (r RegisterCertificateRequest) Send(ctx context.Context) (*RegisterCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterCertificateResponse{
		RegisterCertificateOutput: r.Request.Data.(*RegisterCertificateOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterCertificateResponse is the response type for the
// RegisterCertificate API operation.
type RegisterCertificateResponse struct {
	*RegisterCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterCertificate request.
func (r *RegisterCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
